/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.file.family.pdf.xref;

import com.ionic.sdk.agent.cipher.file.family.pdf.data.Pdf;
import com.ionic.sdk.agent.cipher.file.family.pdf.data.PdfDictionary;
import com.ionic.sdk.agent.cipher.file.family.pdf.io.PdfDictionaryWriter;
import com.ionic.sdk.agent.cipher.file.family.pdf.xref.Xref;
import com.ionic.sdk.agent.cipher.file.family.pdf.xref.XrefTable;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.value.Value;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

@InternalUseOnly
public final class XrefTableWriter {
    private final PrintStream printStream;

    public XrefTableWriter(OutputStream outputStream) throws UnsupportedEncodingException {
        this.printStream = new PrintStream(outputStream, false, Pdf.CHARSET);
    }

    public void write(int startObjectNumber, XrefTable xrefTable) {
        this.printStream.print(Value.join(" ", startObjectNumber, xrefTable.size()));
        this.printStream.print("\n");
        for (Xref xref : xrefTable.values()) {
            this.printStream.print(String.format("%010d %05d %s", xref.getOffset(), xref.getGenerationNum(), xref.getInUse()));
            this.printStream.print(" ");
            this.printStream.print("\n");
        }
        this.printStream.flush();
    }

    public void write(PdfDictionary dictionary) throws UnsupportedEncodingException {
        new PdfDictionaryWriter(this.printStream).write(dictionary, false);
    }
}

