/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.cipher.raw;

import com.ionic.sdk.agent.cipher.data.DecryptAttributes;
import com.ionic.sdk.agent.cipher.data.EncryptAttributes;
import com.ionic.sdk.agent.key.AgentKey;
import com.ionic.sdk.agent.request.createkey.CreateKeysResponse;
import com.ionic.sdk.agent.request.getkey.GetKeysResponse;
import com.ionic.sdk.cipher.aes.AesCtrCipher;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.key.KeyServices;
import java.nio.ByteBuffer;

public class RawCipherAesCtr {
    private final KeyServices agent;

    public RawCipherAesCtr(KeyServices agent) {
        this.agent = agent;
    }

    public final byte[] encrypt(byte[] plainText, EncryptAttributes encryptAttributes) throws IonicException {
        SdkData.checkNotNull(this.agent, KeyServices.class.getName());
        SdkData.checkNotNull(plainText, byte[].class.getName());
        SdkData.checkNotNull(encryptAttributes, EncryptAttributes.class.getName());
        byte[] cipherText = new byte[plainText.length + 16];
        ByteBuffer plainBuffer = ByteBuffer.wrap(plainText);
        ByteBuffer cipherBuffer = ByteBuffer.wrap(cipherText);
        CreateKeysResponse createKeysResponse = this.agent.createKey(encryptAttributes.getKeyAttributes(), encryptAttributes.getMutableKeyAttributes(), encryptAttributes.getMetadata());
        CreateKeysResponse.Key key = createKeysResponse.getFirstKey();
        encryptAttributes.setKeyResponse(key);
        AesCtrCipher cipher = new AesCtrCipher(key.getSecretKey());
        int count = cipher.encrypt(plainBuffer, cipherBuffer);
        SdkData.checkTrue(cipherText.length == count, 40001);
        return cipherText;
    }

    public final byte[] decrypt(byte[] cipherText, String keyId, DecryptAttributes decryptAttributes) throws IonicException {
        SdkData.checkNotNull(this.agent, KeyServices.class.getName());
        SdkData.checkNotNull(cipherText, byte[].class.getName());
        SdkData.checkNotNull(keyId, AgentKey.class.getName());
        SdkData.checkNotNull(decryptAttributes, DecryptAttributes.class.getName());
        byte[] plainText = new byte[cipherText.length - 16];
        ByteBuffer cipherBuffer = ByteBuffer.wrap(cipherText);
        ByteBuffer plainBuffer = ByteBuffer.wrap(plainText);
        GetKeysResponse getKeysResponse = this.agent.getKey(keyId, decryptAttributes.getMetadata());
        GetKeysResponse.Key key = getKeysResponse.getFirstKey();
        decryptAttributes.setKeyResponse(key);
        AesCtrCipher cipher = new AesCtrCipher(key.getSecretKey());
        int count = cipher.decrypt(plainBuffer, cipherBuffer);
        SdkData.checkTrue(plainText.length == count, 40001);
        return plainText;
    }
}

