/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.config;

import java.util.Map;
import java.util.Properties;

public class AgentConfig {
    private final Properties properties = new Properties();
    private String userAgent;
    private String httpImpl;
    private int httpTimeoutSecs;
    private int maxRedirects;
    private String originFile;
    private static final int HTTP_TIMEOUT_SECS_DEFAULT = 30;
    private static final int HTTP_REDIRECTS_DEFAULT = 2;

    public AgentConfig() {
        this.clearInternal();
    }

    public AgentConfig(AgentConfig agentConfig) {
        this();
        this.properties.putAll((Map<?, ?>)agentConfig.properties);
        this.setUserAgent(agentConfig.getUserAgent());
        this.setHttpImpl(agentConfig.getHttpImpl());
        this.setHttpTimeoutSecs(agentConfig.getHttpTimeoutSecs());
        this.setMaxRedirects(agentConfig.getMaxRedirects());
        this.originFile = agentConfig.getOriginFile();
    }

    public final void clear() {
        this.clearInternal();
    }

    private void clearInternal() {
        this.properties.clear();
        this.userAgent = "Ionic Fusion Agent";
        this.httpImpl = "";
        this.httpTimeoutSecs = 30;
        this.maxRedirects = 2;
        this.originFile = "";
    }

    public final void initialize(AgentConfig agentConfig) {
        this.clearInternal();
        this.properties.putAll((Map<?, ?>)agentConfig.properties);
        this.setUserAgent(agentConfig.getUserAgent());
        this.setHttpImpl(agentConfig.getHttpImpl());
        this.setHttpTimeoutSecs(agentConfig.getHttpTimeoutSecs());
        this.setMaxRedirects(agentConfig.getMaxRedirects());
        this.originFile = agentConfig.getOriginFile();
    }

    public final boolean isValid() {
        return this.userAgent != null && !this.userAgent.isEmpty();
    }

    public final void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public final String getUserAgent() {
        return this.userAgent;
    }

    public final void setHttpImpl(String httpImpl) {
        this.httpImpl = httpImpl;
    }

    public final String getHttpImpl() {
        return this.httpImpl;
    }

    public final void setHttpTimeoutSecs(int httpTimeoutSecs) {
        this.httpTimeoutSecs = httpTimeoutSecs;
    }

    public final int getHttpTimeoutSecs() {
        return this.httpTimeoutSecs;
    }

    public final void setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
    }

    public final int getMaxRedirects() {
        return this.maxRedirects;
    }

    public final void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public final String getProperty(String name, String defaultValue) {
        return this.properties.getProperty(name, defaultValue);
    }

    public final String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public final boolean getPropertyBool(String name, boolean defaultValue) {
        String value = this.properties.getProperty(name);
        if (value == null) {
            return defaultValue;
        }
        return !"0".equals(value) && !"false".equals(value) && !"no".equals(value);
    }

    public final String getOriginFile() {
        return this.originFile;
    }

    public static class Key {
        public static final String AUTOSELECT_PROFILE = "autoselectprofile";
    }
}

