/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.key;

import com.ionic.sdk.agent.key.KeyAttributesMap;
import com.ionic.sdk.agent.key.KeyBase;
import com.ionic.sdk.agent.key.KeyMetadata;
import com.ionic.sdk.agent.key.KeyObligationsMap;
import com.ionic.sdk.core.value.Value;
import java.io.Serializable;
import java.util.Objects;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AgentKey
implements Serializable,
KeyBase,
KeyMetadata {
    private String keyId;
    private byte[] keyBytes;
    private KeyAttributesMap keyAttributes;
    private String attributesSigBase64FromServer;
    private KeyAttributesMap mutableAttributes;
    private KeyAttributesMap mutableAttributesFromServer;
    private String mutableAttributesSigBase64FromServer;
    private KeyObligationsMap keyObligations;
    private String origin;
    private static final long serialVersionUID = 6534194716468482558L;

    public AgentKey() {
        this("", new byte[0]);
    }

    public AgentKey(AgentKey key) {
        this(key.keyId, key.keyBytes, key.keyAttributes, key.mutableAttributes, key.keyObligations);
        this.mutableAttributesFromServer = key.mutableAttributesFromServer;
        this.attributesSigBase64FromServer = key.attributesSigBase64FromServer;
        this.mutableAttributesSigBase64FromServer = key.mutableAttributesSigBase64FromServer;
        this.origin = key.origin;
    }

    public AgentKey(String keyId, byte[] keyBytes) throws NullPointerException {
        this(keyId, keyBytes, new KeyAttributesMap(), new KeyObligationsMap());
    }

    public AgentKey(String keyId, byte[] keyBytes, KeyAttributesMap keyAttributes, KeyObligationsMap keyObligations) throws NullPointerException {
        this(keyId, keyBytes, keyAttributes, new KeyAttributesMap(), keyObligations);
    }

    public AgentKey(String keyId, byte[] keyBytes, KeyAttributesMap keyAttributes, KeyAttributesMap mutableAttributes, KeyObligationsMap keyObligations) throws NullPointerException {
        if (keyBytes == null) {
            throw new NullPointerException("cannot have null keyBytes");
        }
        this.keyId = Objects.requireNonNull(keyId, "keyId must not be null");
        this.keyBytes = (byte[])Objects.requireNonNull(keyBytes.clone(), "keyBytes must not be null");
        this.keyAttributes = new KeyAttributesMap(keyAttributes);
        this.mutableAttributes = new KeyAttributesMap(mutableAttributes);
        this.mutableAttributesFromServer = new KeyAttributesMap(mutableAttributes);
        this.keyObligations = new KeyObligationsMap(keyObligations);
        this.attributesSigBase64FromServer = "";
        this.mutableAttributesSigBase64FromServer = "";
    }

    @Override
    public final String getId() {
        return this.keyId;
    }

    @Override
    public final void setId(String keyId) throws NullPointerException {
        this.keyId = Objects.requireNonNull(keyId, "keyId must not be null");
    }

    @Override
    public final byte[] getKey() {
        return (byte[])this.keyBytes.clone();
    }

    @Override
    public final void setKey(byte[] keyBytes) throws NullPointerException {
        this.keyBytes = (byte[])Objects.requireNonNull(keyBytes.clone(), "keyBytes must not be null");
    }

    public final SecretKey getSecretKey() {
        return new SecretKeySpec(this.keyBytes, 0, this.keyBytes.length, "AES");
    }

    @Override
    public final KeyAttributesMap getAttributesMap() {
        return this.keyAttributes;
    }

    @Override
    public final void setAttributesMap(KeyAttributesMap keyAttributes) {
        this.keyAttributes = keyAttributes == null ? new KeyAttributesMap() : keyAttributes;
    }

    @Override
    public final KeyAttributesMap getMutableAttributesMap() {
        return this.mutableAttributes;
    }

    @Override
    public final void setMutableAttributesMap(KeyAttributesMap mutableAttributes) {
        this.mutableAttributes = mutableAttributes == null ? new KeyAttributesMap() : mutableAttributes;
    }

    @Deprecated
    public final KeyAttributesMap getMutableAttributes() {
        return this.mutableAttributes;
    }

    @Deprecated
    public final void setMutableAttributes(KeyAttributesMap mutableAttributes) {
        this.mutableAttributes = mutableAttributes == null ? new KeyAttributesMap() : mutableAttributes;
    }

    public final KeyAttributesMap getMutableAttributesMapFromServer() {
        return this.mutableAttributesFromServer;
    }

    public final void setMutableAttributesMapFromServer(KeyAttributesMap mutableAttributesFromServer) {
        this.mutableAttributesFromServer = mutableAttributesFromServer == null ? new KeyAttributesMap() : mutableAttributesFromServer;
    }

    @Deprecated
    public final KeyAttributesMap getMutableAttributesFromServer() {
        return this.mutableAttributesFromServer;
    }

    @Deprecated
    public final void setMutableAttributesFromServer(KeyAttributesMap mutableAttributesFromServer) {
        this.mutableAttributesFromServer = mutableAttributesFromServer == null ? new KeyAttributesMap() : mutableAttributesFromServer;
    }

    @Override
    public final KeyObligationsMap getObligationsMap() {
        return this.keyObligations;
    }

    @Override
    public final void setObligationsMap(KeyObligationsMap keyObligations) {
        this.keyObligations = keyObligations == null ? new KeyObligationsMap() : keyObligations;
    }

    public final String getAttributesSigBase64FromServer() {
        return this.attributesSigBase64FromServer;
    }

    public final void setAttributesSigBase64FromServer(String attributesSigBase64FromServer) {
        this.attributesSigBase64FromServer = attributesSigBase64FromServer;
    }

    public final String getMutableAttributesSigBase64FromServer() {
        return this.mutableAttributesSigBase64FromServer;
    }

    public final void setMutableAttributesSigBase64FromServer(String mutableAttributesSigBase64FromServer) {
        this.mutableAttributesSigBase64FromServer = mutableAttributesSigBase64FromServer;
    }

    public final String getOrigin() {
        return this.origin;
    }

    public final void setOrigin(String origin) {
        this.origin = Value.defaultOnEmpty(origin, "");
    }
}

