/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.key.merge;

import com.ionic.sdk.agent.key.KeyAttributesMap;
import com.ionic.sdk.agent.key.merge.KeyAttributesMapMerger;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;

public class KeyAttributesMapMergerDefault
implements KeyAttributesMapMerger {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public final KeyAttributesMap mergeKeyAttributeMaps(boolean attributesAreMutable, KeyAttributesMap originalServerAttributes, KeyAttributesMap currentServerAttributes, KeyAttributesMap clientAttributes) {
        KeyAttributesMap mergedAttributes = new KeyAttributesMap(currentServerAttributes);
        this.mergeKeyAttributeMapsInternal(attributesAreMutable, originalServerAttributes, currentServerAttributes, clientAttributes, mergedAttributes);
        return mergedAttributes;
    }

    @Override
    public final int mergeKeyAttributeMaps(boolean attributesAreMutable, KeyAttributesMap originalServerAttributes, KeyAttributesMap currentServerAttributes, KeyAttributesMap clientAttributes, KeyAttributesMap mergedAttributes) {
        return this.mergeKeyAttributeMapsInternal(attributesAreMutable, originalServerAttributes, currentServerAttributes, clientAttributes, mergedAttributes);
    }

    private int mergeKeyAttributeMapsInternal(boolean attributesAreMutable, KeyAttributesMap originalServerAttributes, KeyAttributesMap currentServerAttributes, KeyAttributesMap clientAttributes, KeyAttributesMap mergedAttributes) {
        KeyAttributesMap finalAttributes = new KeyAttributesMap(currentServerAttributes);
        ListIterator origIter = new ArrayList(originalServerAttributes.keySet()).listIterator();
        ListIterator clientIter = new ArrayList(clientAttributes.keySet()).listIterator();
        while (origIter.hasNext() || clientIter.hasNext()) {
            ArrayList<String> mergedValues;
            List<String> clientValues;
            String origKey;
            if (!origIter.hasNext()) {
                String clientKey = (String)clientIter.next();
                List<String> clientValues2 = clientAttributes.get(clientKey);
                ArrayList<String> mergedValues2 = new ArrayList<String>();
                this.mergeKeyAttributeValues(new ArrayList<String>(), finalAttributes.get(clientKey), clientValues2, mergedValues2);
                finalAttributes.put(clientKey, mergedValues2);
                continue;
            }
            if (!clientIter.hasNext()) {
                origKey = (String)origIter.next();
                finalAttributes.remove(origKey);
                continue;
            }
            origKey = (String)origIter.next();
            String clientKey = (String)clientIter.next();
            origIter.previous();
            clientIter.previous();
            if (clientKey.compareTo(origKey) < 0) {
                clientValues = clientAttributes.get(clientKey);
                mergedValues = new ArrayList<String>();
                this.mergeKeyAttributeValues(new ArrayList<String>(), finalAttributes.get(clientKey), clientValues, mergedValues);
                finalAttributes.put(clientKey, mergedValues);
                clientIter.next();
                continue;
            }
            if (origKey.compareTo(clientKey) < 0) {
                finalAttributes.remove(origKey);
                origIter.next();
                continue;
            }
            if (finalAttributes.containsKey(clientKey)) {
                clientValues = clientAttributes.get(clientKey);
                mergedValues = new ArrayList();
                this.mergeKeyAttributeValues(originalServerAttributes.get(origKey), finalAttributes.get(clientKey), clientValues, mergedValues);
                finalAttributes.put(clientKey, mergedValues);
            }
            origIter.next();
            clientIter.next();
        }
        mergedAttributes.clear();
        mergedAttributes.putAll(finalAttributes);
        this.logger.finest(String.format("mergedAttributes = %s", mergedAttributes.toString()));
        return 0;
    }

    private void mergeKeyAttributeValues(List<String> originalServerValues, List<String> currentServerValues, List<String> currentClientValues, List<String> mergedValues) {
        ArrayList currentServerValuesNN = currentServerValues == null ? new ArrayList() : currentServerValues;
        ArrayList<String> finalValues = new ArrayList<String>(currentServerValuesNN);
        for (String originalServerValue : originalServerValues) {
            if (currentClientValues.contains(originalServerValue)) continue;
            finalValues.remove(originalServerValue);
        }
        for (String currentClientValue : currentClientValues) {
            if (originalServerValues.contains(currentClientValue) || finalValues.contains(currentClientValue)) continue;
            finalValues.add(currentClientValue);
        }
        mergedValues.clear();
        mergedValues.addAll(finalValues);
        this.logger.finest(String.format("mergedValues = %s", mergedValues.toString()));
    }
}

