/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.request.base;

import com.ionic.sdk.agent.Agent;
import com.ionic.sdk.agent.ServiceProtocol;
import com.ionic.sdk.agent.config.AgentConfig;
import com.ionic.sdk.agent.request.base.AgentRequestBase;
import com.ionic.sdk.agent.request.base.AgentResponseBase;
import com.ionic.sdk.agent.transaction.AgentTransactionUtil;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.device.DeviceUtils;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.IonicServerException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.httpclient.HttpClient;
import com.ionic.sdk.httpclient.HttpClientFactory;
import com.ionic.sdk.httpclient.HttpHeader;
import com.ionic.sdk.httpclient.HttpHeaders;
import com.ionic.sdk.httpclient.HttpRequest;
import com.ionic.sdk.httpclient.HttpResponse;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonSource;
import java.io.IOException;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Logger;
import javax.json.JsonObject;
import javax.json.JsonValue;

@InternalUseOnly
public abstract class AgentTransactionBase {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final ServiceProtocol protocol;
    private final AgentRequestBase requestBase;
    private final AgentResponseBase responseBase;
    private static final int MAX_RECOVERY_ATTEMPTS = 3;

    public AgentTransactionBase(ServiceProtocol protocol, AgentRequestBase requestBase, AgentResponseBase responseBase) {
        this.protocol = protocol;
        this.requestBase = requestBase;
        this.responseBase = responseBase;
    }

    public ServiceProtocol getProtocol() {
        return this.protocol;
    }

    protected final AgentRequestBase getRequestBase() {
        return this.requestBase;
    }

    protected final AgentResponseBase getResponseBase() {
        return this.responseBase;
    }

    public final void run() throws IonicException {
        SdkData.checkTrue(this.protocol.isInitialized(), 40006);
        if (this.isIdentityNeeded()) {
            SdkData.checkTrue(this.protocol.hasIdentity(), 40022);
            try {
                this.protocol.isValidIdentity();
            }
            catch (IonicException e) {
                throw new IonicException(40022, (Throwable)e);
            }
        }
        Properties fingerprint = new Properties();
        fingerprint.setProperty("hfphash", this.protocol.getFingerprint().getHfpHash());
        TreeSet<Integer> autoRecoverErrorsHandled = new TreeSet<Integer>();
        for (int attempt = 1; attempt <= 3; ++attempt) {
            try {
                this.runWithFingerprint(fingerprint);
                break;
            }
            catch (IonicException e) {
                if (this.handleException(attempt, e, autoRecoverErrorsHandled, fingerprint)) continue;
                throw e;
            }
        }
    }

    private void runWithFingerprint(Properties fingerprint) throws IonicException {
        HttpRequest httpRequest = this.buildHttpRequest(fingerprint);
        AgentConfig config = this.protocol.getConfig();
        HttpClient httpClientIDC = HttpClientFactory.create(config, httpRequest.getUrl().getProtocol());
        try {
            HttpResponse httpResponse = httpClientIDC.execute(httpRequest);
            this.parseHttpResponse(httpRequest, httpResponse);
        }
        catch (IOException e) {
            throw new IonicException(40009, (Throwable)e);
        }
    }

    private boolean handleException(int attempt, IonicException exception, Set<Integer> errorsHandled, Properties fingerprint) {
        boolean handled = false;
        Integer returnCode = exception.getReturnCode();
        if (errorsHandled.contains(returnCode)) {
            this.logger.warning(String.format("Recoverable error encountered during %s.  Recovery attempt %d. Error code: %d", this.getClass().getSimpleName(), attempt, returnCode));
        } else if (returnCode == 40025) {
            errorsHandled.add(returnCode);
            this.handleFingerprintDeniedError(fingerprint);
            handled = true;
        } else if (returnCode == 40027 && this.handleCidTimestampDeniedError()) {
            errorsHandled.add(returnCode);
            handled = true;
        }
        return handled;
    }

    private void handleFingerprintDeniedError(Properties fingerprint) {
        fingerprint.setProperty("hfp", this.protocol.getFingerprint().getHfp());
        fingerprint.setProperty("hfphash", this.protocol.getFingerprint().getHfpHash());
    }

    protected final void parseHttpResponseBase(HttpRequest httpRequest, HttpResponse httpResponse, String cidQ) throws IonicException {
        this.responseBase.setHttpResponseCode(httpResponse.getStatusCode());
        if (AgentTransactionUtil.isHttpErrorCode(httpResponse.getStatusCode())) {
            this.logger.severe(String.format("Received unexpected response code from server.  Expected 200-299, got %d, CID=%s.", httpResponse.getStatusCode(), cidQ));
        }
        String contentType = httpResponse.getHttpHeaders().getHeaderValue("Content-Type");
        SdkData.checkNotNull(contentType, "Content-Type");
        SdkData.checkTrue(contentType.contains("application/json"), 40015);
        byte[] entitySecure = DeviceUtils.read(httpResponse.getEntity());
        byte[] entityClear = this.protocol.transformResponsePayload(entitySecure, cidQ);
        JsonObject jsonPayload = JsonIO.readObject(entityClear);
        JsonObject error = JsonSource.getJsonObjectNullable(jsonPayload, "error");
        this.responseBase.setConversationId(cidQ == null ? JsonSource.getString(jsonPayload, "cid") : cidQ);
        this.responseBase.setJsonPayload(jsonPayload);
        this.responseBase.setServerErrorCode(error == null ? 0 : JsonSource.getInt(error, "code"));
        this.responseBase.setServerErrorMessage(error == null ? null : JsonSource.getString(error, "message"));
        this.responseBase.setServerErrorDataJson(error == null ? null : JsonIO.write(error, false));
        if (this.responseBase.getServerErrorDataJson() != null) {
            this.logger.severe(this.responseBase.getServerErrorDataJson());
        }
        try {
            this.processResponseErrorServer(cidQ);
        }
        catch (IonicServerException e) {
            throw new IonicException(e.getReturnCode(), (Throwable)e);
        }
    }

    private void processResponseErrorServer(String cid) throws IonicServerException {
        switch (this.responseBase.getServerErrorCode()) {
            case 4001: {
                throw new IonicServerException(40025, cid, this.responseBase);
            }
            case 4002: {
                throw new IonicServerException(40027, cid, this.responseBase);
            }
            case 0: {
                this.processResponseErrorHttp(cid);
                break;
            }
            default: {
                throw new IonicServerException(40009, cid, this.responseBase);
            }
        }
    }

    private boolean handleCidTimestampDeniedError() {
        this.logger.finest("Server has denied our CID timestamp.  Auto-calibrating server time offset.");
        if (this.getResponseBase().getServerErrorDataJson().length() == 0) {
            this.logger.severe("Server did not provide any data along with the CID timestamp error.");
            return false;
        }
        JsonObject rootValue = null;
        try {
            rootValue = JsonIO.readObject(this.getResponseBase().getServerErrorDataJson(), 40010);
        }
        catch (IonicException e) {
            this.logger.severe("Failed to parse error data provided with the CID timestamp error.");
            return false;
        }
        if (rootValue == null || rootValue.getValueType() != JsonValue.ValueType.NUMBER) {
            this.logger.severe("The error data provided with the CID timestamp error does not contain an integer.");
            return false;
        }
        Agent.calibrateServerTimeOffsetMillis(JsonSource.toLong((JsonValue)rootValue));
        return true;
    }

    private void processResponseErrorHttp(String cid) throws IonicServerException {
        if (AgentTransactionUtil.isHttpErrorCode(this.responseBase.getHttpResponseCode())) {
            throw new IonicServerException(40009, cid, this.responseBase);
        }
        this.processResponseErrorData(cid);
    }

    private void processResponseErrorData(String cid) throws IonicServerException {
        JsonObject jsonPayload = this.responseBase.getJsonPayload();
        JsonValue.ValueType valueType = JsonSource.getValueType(jsonPayload, "data");
        if (!JsonValue.ValueType.OBJECT.equals((Object)valueType) && this.responseBase.isDataRequired()) {
            throw new IonicServerException(40015, cid, this.responseBase);
        }
    }

    protected final HttpHeaders getHttpHeaders() {
        HttpHeaders httpHeaders = new HttpHeaders(new HttpHeader[0]);
        httpHeaders.add(new HttpHeader("Content-Type", "application/json; charset=utf-8"));
        httpHeaders.add(new HttpHeader("User-Agent", this.protocol.getConfig().getUserAgent()));
        httpHeaders.add(new HttpHeader("Accept-Encoding", "gzip,deflate"));
        this.protocol.addHeader(httpHeaders);
        return httpHeaders;
    }

    protected abstract HttpRequest buildHttpRequest(Properties var1) throws IonicException;

    protected abstract void parseHttpResponse(HttpRequest var1, HttpResponse var2) throws IonicException;

    protected boolean isIdentityNeeded() {
        return true;
    }
}

