/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.request.base;

import com.ionic.sdk.agent.ServiceProtocol;
import com.ionic.sdk.agent.key.KeyAttributesMap;
import com.ionic.sdk.agent.request.base.AgentRequestBase;
import com.ionic.sdk.agent.transaction.AgentTransactionUtil;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonSource;
import com.ionic.sdk.json.JsonTarget;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public abstract class MessageBase {
    private final ServiceProtocol protocol;
    private final String cid;

    public MessageBase(ServiceProtocol protocol) throws IonicException {
        SdkData.checkNotNull(protocol, ServiceProtocol.class.getName());
        this.protocol = protocol;
        this.cid = protocol.generateCid();
    }

    public final ServiceProtocol getProtocol() {
        return this.protocol;
    }

    public final String getCid() {
        return this.cid;
    }

    public final JsonObject getJsonMessage(AgentRequestBase requestBase, Properties fingerprint) throws IonicException {
        return Json.createObjectBuilder().add("data", this.getJsonData(requestBase)).add("meta", (JsonValue)AgentTransactionUtil.buildStandardJsonMeta(this.protocol, requestBase, fingerprint)).build();
    }

    protected final JsonObject generateJsonAttrs(KeyAttributesMap keyAttributes) throws IonicException {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        for (Map.Entry entry : keyAttributes.entrySet()) {
            String key = (String)entry.getKey();
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            for (String value : (List)entry.getValue()) {
                JsonTarget.addNotNull(arrayBuilder, value);
            }
            JsonArray values = arrayBuilder.build();
            if (this.isIonicProtect(key)) {
                JsonTarget.addNotNull(objectBuilder, key, (JsonValue)this.encryptIonicAttrs(key, values));
                continue;
            }
            JsonTarget.addNotNull(objectBuilder, key, (JsonValue)values);
        }
        return objectBuilder.build();
    }

    protected final boolean isIonicProtect(String name) {
        boolean isIonicProtected = name.startsWith("ionic-protected-");
        boolean isIonicIntegrityHash = name.equals("ionic-integrity-hash");
        return isIonicProtected || isIonicIntegrityHash;
    }

    protected final JsonArray encryptIonicAttrs(String name, JsonArray jsonArray) throws IonicException {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        JsonTarget.addNotNull(arrayBuilder, this.protocol.protectAttributes(name, JsonSource.toString((JsonValue)jsonArray)));
        return arrayBuilder.build();
    }

    protected final JsonArray decryptIonicAttrs(JsonValue jsonValue, String keyId, byte[] key) throws IonicException {
        JsonArray jsonArray = JsonSource.toJsonArray(jsonValue, JsonValue.class.getName());
        SdkData.checkTrue(JsonSource.isSize(jsonArray, 1), 40005, JsonArray.class.getName());
        JsonValue jsonValueIt = JsonSource.getIterator(jsonArray).next();
        String value = JsonSource.toString(jsonValueIt);
        String jsonStringArray = this.protocol.unprotectAttributes(keyId, value, key);
        return JsonIO.readArray(jsonStringArray);
    }

    protected abstract JsonValue getJsonData(AgentRequestBase var1) throws IonicException;
}

