/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.request.createdevice;

import com.ionic.sdk.agent.ServiceProtocol;
import com.ionic.sdk.agent.request.base.AgentRequestBase;
import com.ionic.sdk.agent.request.base.AgentResponseBase;
import com.ionic.sdk.agent.request.base.AgentTransactionBase;
import com.ionic.sdk.agent.request.createdevice.CreateDeviceRequest;
import com.ionic.sdk.agent.request.createdevice.CreateDeviceResponse;
import com.ionic.sdk.agent.transaction.AgentTransactionUtil;
import com.ionic.sdk.cipher.aes.AesCtrCipher;
import com.ionic.sdk.cipher.aes.model.AesKeyGenerator;
import com.ionic.sdk.cipher.aes.model.AesKeyHolder;
import com.ionic.sdk.cipher.rsa.RsaCipher;
import com.ionic.sdk.cipher.rsa.model.RsaKeyGenerator;
import com.ionic.sdk.cipher.rsa.model.RsaKeyHolder;
import com.ionic.sdk.cipher.rsa.model.RsaKeyPersistor;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.crypto.CryptoUtils;
import com.ionic.sdk.device.profile.DeviceProfile;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.error.SdkError;
import com.ionic.sdk.httpclient.HttpHeader;
import com.ionic.sdk.httpclient.HttpHeaders;
import com.ionic.sdk.httpclient.HttpRequest;
import com.ionic.sdk.httpclient.HttpResponse;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonSource;
import java.io.ByteArrayInputStream;
import java.net.URL;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObject;

@InternalUseOnly
public class CreateDeviceTransaction
extends AgentTransactionBase {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final String cid;
    private final RsaKeyHolder rsaKeyHolder;
    private final AesKeyHolder aesKeyHolder;
    private static final String REGEX_CREATE_DEVICE_RESPONSE_CID = "CID\\|ENROLLMENT\\|(\\S+)\\|\\S+\\|\\d+\\|\\S+";

    public CreateDeviceTransaction(ServiceProtocol protocol, AgentRequestBase requestBase, AgentResponseBase responseBase) throws IonicException {
        super(protocol, requestBase, responseBase);
        int errorCode = 40001;
        SdkData.checkTrue(requestBase instanceof CreateDeviceRequest, 40001, SdkError.getErrorString(40001));
        CreateDeviceRequest request = (CreateDeviceRequest)requestBase;
        RsaKeyHolder keyHolder = request.getRsaKeyHolder();
        this.cid = UUID.randomUUID().toString();
        this.rsaKeyHolder = keyHolder == null ? new RsaKeyGenerator().generate(3072) : keyHolder;
        this.aesKeyHolder = new AesKeyGenerator().generate();
    }

    @Override
    protected final HttpRequest buildHttpRequest(Properties fingerprint) throws IonicException {
        AgentRequestBase agentRequestBase = this.getRequestBase();
        SdkData.checkTrue(agentRequestBase instanceof CreateDeviceRequest, 40001);
        CreateDeviceRequest request = (CreateDeviceRequest)agentRequestBase;
        this.logger.fine(request.getToken());
        String pubkeySessionB64 = new RsaKeyPersistor().toBase64Public(this.rsaKeyHolder);
        String authdata = Value.join(",", request.getToken(), request.getUidAuth());
        String authdataB64 = CryptoUtils.binToBase64(Transcoder.utf8().decode(authdata));
        JsonObject jsonPayloadRoot = Json.createObjectBuilder().add("TKRespPubKDERB64", pubkeySessionB64).add("AUTH", authdataB64).build();
        String payloadPlainText = JsonIO.write(jsonPayloadRoot, false);
        AesCtrCipher cipherAES = new AesCtrCipher();
        cipherAES.setKey(this.aesKeyHolder.getKey().getEncoded());
        String payloadSecureB64 = cipherAES.encryptToBase64(payloadPlainText);
        this.logger.fine(payloadSecureB64);
        RsaKeyHolder rsaKeyHolderEI = new RsaKeyPersistor().fromBase64(request.getEiRsaPublicKey(), null);
        RsaCipher cipherRSAEI = new RsaCipher();
        cipherRSAEI.setKeypairInstance(rsaKeyHolderEI.getKeypair());
        byte[] encrypt = cipherRSAEI.encrypt(this.aesKeyHolder.getKey().getEncoded());
        String aesSessionKeyB64 = CryptoUtils.binToBase64(encrypt);
        this.logger.fine(aesSessionKeyB64);
        RsaCipher cipherRSASession = new RsaCipher();
        cipherRSASession.setKeypairInstance(this.rsaKeyHolder.getKeypair());
        String signatureB64 = cipherRSASession.sign(Transcoder.utf8().decode(payloadSecureB64));
        this.logger.fine(signatureB64);
        JsonObject jsonRequestRoot = Json.createObjectBuilder().add("g", signatureB64).add("k", request.getEtag()).add("p", payloadSecureB64).add("s", aesSessionKeyB64).build();
        String entitySecure = JsonIO.write(jsonRequestRoot, false);
        this.logger.fine(entitySecure);
        String resource = String.format("/%s/register/%s", "v2.4", request.getEtag());
        URL url = AgentTransactionUtil.getProfileUrl(request.getServer());
        this.logger.fine(request.getServer());
        ByteArrayInputStream bis = new ByteArrayInputStream(Transcoder.utf8().decode(JsonIO.write(jsonRequestRoot, false)));
        HttpHeaders httpHeaders = this.getHttpHeaders();
        httpHeaders.add(new HttpHeader("X-Conversation-ID", this.cid));
        return new HttpRequest(url, "POST", resource, httpHeaders, bis);
    }

    @Override
    protected final void parseHttpResponse(HttpRequest httpRequest, HttpResponse httpResponse) throws IonicException {
        this.parseHttpResponseBase(httpRequest, httpResponse, null);
        AgentRequestBase agentRequestBase = this.getRequestBase();
        AgentResponseBase agentResponseBase = this.getResponseBase();
        SdkData.checkTrue(agentRequestBase instanceof CreateDeviceRequest, 40001);
        SdkData.checkTrue(agentResponseBase instanceof CreateDeviceResponse, 40001);
        CreateDeviceRequest request = (CreateDeviceRequest)agentRequestBase;
        CreateDeviceResponse response = (CreateDeviceResponse)agentResponseBase;
        String cidResponse = response.getConversationId();
        Matcher matcher = Pattern.compile(REGEX_CREATE_DEVICE_RESPONSE_CID).matcher(cidResponse);
        SdkData.checkTrue(matcher.matches(), 40011);
        SdkData.checkTrue(this.cid.equals(matcher.group(1)), 40011);
        JsonObject json = response.getJsonPayload();
        String deviceId = JsonSource.getString(json, "deviceID");
        String sepAesk = JsonSource.getString(json, "SEPAESK");
        String sepAeskIdc = JsonSource.getString(json, "SEPAESK-IDC");
        AesCtrCipher aesCipher = new AesCtrCipher();
        aesCipher.setKey(this.aesKeyHolder.getKey().getEncoded());
        byte[] keyEI = aesCipher.decrypt(CryptoUtils.base64ToBin(sepAesk));
        RsaCipher rsaCipher = new RsaCipher();
        rsaCipher.setKeypairInstance(this.rsaKeyHolder.getKeypair());
        byte[] keyIDC = rsaCipher.decrypt(CryptoUtils.base64ToBin(sepAeskIdc));
        long creationTimestamp = System.currentTimeMillis() / 1000L;
        DeviceProfile deviceProfile = new DeviceProfile(request.getDeviceProfileName(), creationTimestamp, deviceId, request.getServer(), keyIDC, keyEI);
        response.setDeviceProfile(deviceProfile);
    }

    @Override
    protected final boolean isIdentityNeeded() {
        return false;
    }
}

