/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.request.createkey;

import com.ionic.sdk.agent.ServiceProtocol;
import com.ionic.sdk.agent.request.base.AgentRequestBase;
import com.ionic.sdk.agent.request.base.MessageBase;
import com.ionic.sdk.agent.request.createkey.CreateKeysRequest;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonTarget;
import java.util.ArrayList;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class CreateKeysMessage
extends MessageBase {
    private final Properties csigs = new Properties();
    private final Properties msigs = new Properties();

    public CreateKeysMessage(ServiceProtocol protocol) throws IonicException {
        super(protocol);
    }

    public final Properties getCsigs() {
        return this.csigs;
    }

    public final Properties getMsigs() {
        return this.msigs;
    }

    protected final JsonObject getJsonData(AgentRequestBase requestBase) throws IonicException {
        SdkData.checkTrue(requestBase instanceof CreateKeysRequest, 40001);
        CreateKeysRequest createKeysRequest = (CreateKeysRequest)requestBase;
        return Json.createObjectBuilder().add("protection-keys", (JsonValue)this.getJsonProtectionKeys(createKeysRequest)).build();
    }

    private JsonArray getJsonProtectionKeys(CreateKeysRequest createKeysRequest) throws IonicException {
        String cid = this.getCid();
        ArrayList<JsonObject> jsonProtectionKeys = new ArrayList<JsonObject>();
        for (CreateKeysRequest.Key key : createKeysRequest.getKeys()) {
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            String refId = key.getRefId();
            JsonTarget.addNotNull(objectBuilder, "ref", refId);
            JsonTarget.add(objectBuilder, "qty", key.getQuantity());
            String cattrs = JsonIO.write(super.generateJsonAttrs(key.getAttributesMap()), false);
            String mattrs = JsonIO.write(super.generateJsonAttrs(key.getMutableAttributesMap()), false);
            JsonTarget.addNotNull(objectBuilder, "cattrs", cattrs);
            JsonTarget.addNotNull(objectBuilder, "mattrs", mattrs);
            String csig = this.getProtocol().signAttributes(cid, refId, null, this.csigs, cattrs, false);
            String msig = this.getProtocol().signAttributes(cid, refId, null, this.msigs, mattrs, true);
            JsonTarget.addNotNull(objectBuilder, "csig", csig);
            JsonTarget.addNotNull(objectBuilder, "msig", msig);
            JsonObject jsonProtectionKey = objectBuilder.build();
            jsonProtectionKeys.add(jsonProtectionKey);
        }
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        for (JsonObject jsonProtectionKey : jsonProtectionKeys) {
            JsonTarget.addNotNull(jsonArrayBuilder, (JsonValue)jsonProtectionKey);
        }
        return jsonArrayBuilder.build();
    }
}

