/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.request.createkey;

import com.ionic.sdk.agent.ServiceProtocol;
import com.ionic.sdk.agent.key.KeyObligationsMap;
import com.ionic.sdk.agent.request.base.AgentRequestBase;
import com.ionic.sdk.agent.request.base.AgentResponseBase;
import com.ionic.sdk.agent.request.base.AgentTransactionBase;
import com.ionic.sdk.agent.request.createkey.CreateKeysMessage;
import com.ionic.sdk.agent.request.createkey.CreateKeysRequest;
import com.ionic.sdk.agent.request.createkey.CreateKeysResponse;
import com.ionic.sdk.agent.transaction.AgentTransactionUtil;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.httpclient.HttpRequest;
import com.ionic.sdk.httpclient.HttpResponse;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonSource;
import java.io.ByteArrayInputStream;
import java.util.Properties;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;

@InternalUseOnly
public class CreateKeysTransaction
extends AgentTransactionBase {
    private CreateKeysMessage message = null;

    public CreateKeysTransaction(ServiceProtocol protocol, AgentRequestBase requestBase, AgentResponseBase responseBase) {
        super(protocol, requestBase, responseBase);
    }

    @Override
    protected final HttpRequest buildHttpRequest(Properties fingerprint) throws IonicException {
        this.message = new CreateKeysMessage(this.getProtocol());
        AgentRequestBase agentRequestBase = this.getRequestBase();
        SdkData.checkTrue(agentRequestBase instanceof CreateKeysRequest, 40001);
        CreateKeysRequest request = (CreateKeysRequest)agentRequestBase;
        JsonObject jsonMessage = this.message.getJsonMessage(request, fingerprint);
        String resource = this.getProtocol().getResource("v2.4", "/keys/create");
        byte[] envelope = Transcoder.utf8().decode(JsonIO.write(jsonMessage, false));
        byte[] envelopeSecure = this.getProtocol().transformRequestPayload(envelope, this.message.getCid());
        ByteArrayInputStream bis = new ByteArrayInputStream(envelopeSecure);
        return new HttpRequest(this.getProtocol().getUrl(), "POST", resource, this.getHttpHeaders(), bis);
    }

    @Override
    protected final void parseHttpResponse(HttpRequest httpRequest, HttpResponse httpResponse) throws IonicException {
        this.parseHttpResponseBase(httpRequest, httpResponse, this.message.getCid());
        AgentRequestBase agentRequestBase = this.getRequestBase();
        AgentResponseBase agentResponseBase = this.getResponseBase();
        SdkData.checkTrue(agentRequestBase instanceof CreateKeysRequest, 40001);
        SdkData.checkTrue(agentResponseBase instanceof CreateKeysResponse, 40001);
        CreateKeysRequest request = (CreateKeysRequest)agentRequestBase;
        CreateKeysResponse response = (CreateKeysResponse)agentResponseBase;
        String cid = response.getConversationId();
        JsonObject jsonPayload = response.getJsonPayload();
        JsonObject jsonData = JsonSource.getJsonObject(jsonPayload, "data");
        JsonArray jsonProtectionKeys = JsonSource.getJsonArray(jsonData, "protection-keys");
        for (JsonValue value : jsonProtectionKeys) {
            JsonObject jsonProtectionKey = JsonSource.toJsonObject(value, "protection-keys");
            String ref = JsonSource.getString(jsonProtectionKey, "ref");
            AgentTransactionUtil.checkNotNull(cid, "ref", ref);
            CreateKeysRequest.Key keyRequest = request.getKey(ref);
            String csigQ = this.message.getCsigs().getProperty(ref);
            String msigQ = this.message.getMsigs().getProperty(ref);
            String id = JsonSource.getString(jsonProtectionKey, "id");
            String authData = Value.join(":", cid, ref, id, csigQ, msigQ);
            String keyHex = JsonSource.getString(jsonProtectionKey, "key");
            String csig = JsonSource.getString(jsonProtectionKey, "csig");
            String msig = JsonSource.getString(jsonProtectionKey, "msig");
            byte[] keyBytes = this.getProtocol().getKeyBytes(keyHex, authData);
            response.add(new CreateKeysResponse.Key(ref, id, keyBytes, this.getProtocol().getIdentity(), keyRequest.getAttributesMap(), keyRequest.getMutableAttributesMap(), new KeyObligationsMap(), "ionic-keyserver", csig, msig));
        }
    }
}

