/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.request.getkey;

import com.ionic.sdk.agent.ServiceProtocol;
import com.ionic.sdk.agent.key.KeyAttributesMap;
import com.ionic.sdk.agent.request.base.AgentRequestBase;
import com.ionic.sdk.agent.request.base.MessageBase;
import com.ionic.sdk.agent.request.getkey.GetKeysRequest;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonSource;
import com.ionic.sdk.json.JsonTarget;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class GetKeysMessage
extends MessageBase {
    GetKeysMessage(ServiceProtocol protocol) throws IonicException {
        super(protocol);
    }

    protected final JsonObject getJsonData(AgentRequestBase requestBase) throws IonicException {
        SdkData.checkTrue(requestBase instanceof GetKeysRequest, 40001);
        GetKeysRequest getKeysRequest = (GetKeysRequest)requestBase;
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        JsonTarget.add(objectBuilder, "protection-keys", JsonTarget.toJsonArray(getKeysRequest.getKeyIds()));
        JsonObjectBuilder protectionKeyQueries = Json.createObjectBuilder();
        for (GetKeysRequest.ExternalId id : getKeysRequest.getExternalIdObjects()) {
            JsonObjectBuilder externalId = Json.createObjectBuilder();
            JsonTarget.addNotNull(externalId, "ionic-external-id", id.getExternalId());
            if (id.getQuantity() > 0) {
                JsonTarget.add(externalId, "qty", id.getQuantity());
            }
            JsonTarget.addNotNull(protectionKeyQueries, id.getExternalId(), (JsonValue)externalId.build());
        }
        JsonTarget.add(objectBuilder, "protection-key-queries", protectionKeyQueries.build());
        return objectBuilder.build();
    }

    public final KeyAttributesMap getJsonAttrs(String attrs, String keyId, byte[] keyBytes) throws IonicException {
        KeyAttributesMap keyAttributes = new KeyAttributesMap();
        if (!Value.isEmpty(attrs)) {
            JsonObject jsonObject = JsonIO.readObject(attrs, 40010);
            Iterator<Map.Entry<String, JsonValue>> iterator = JsonSource.getIterator(jsonObject);
            while (iterator.hasNext()) {
                Map.Entry<String, JsonValue> entry = iterator.next();
                String key = entry.getKey();
                JsonValue value = super.isIonicProtect(key) ? super.decryptIonicAttrs(entry.getValue(), keyId, keyBytes) : entry.getValue();
                JsonArray jsonArray = JsonSource.toJsonArray(value, key);
                ArrayList<String> values = new ArrayList<String>();
                for (JsonValue jsonValue : jsonArray) {
                    values.add(JsonSource.toString(jsonValue));
                }
                keyAttributes.put(key, values);
            }
        }
        return keyAttributes;
    }
}

