/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.request.getkey;

import com.ionic.sdk.agent.key.AgentKey;
import com.ionic.sdk.agent.key.KeyAttributesMap;
import com.ionic.sdk.agent.key.KeyObligationsMap;
import com.ionic.sdk.agent.request.base.AgentResponseBase;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class GetKeysResponse
extends AgentResponseBase {
    private final List<Key> keys = new ArrayList<Key>();
    private final List<IonicError> errors = new ArrayList<IonicError>();
    private final List<QueryResult> results = new ArrayList<QueryResult>();
    private static final long serialVersionUID = -8256370090345978102L;

    public final List<Key> getKeys() {
        return this.keys;
    }

    public final List<IonicError> getErrors() {
        return this.errors;
    }

    public final List<QueryResult> getQueryResults() {
        return this.results;
    }

    public final Key getFirstKey() throws IonicException {
        SdkData.checkTrue(!this.keys.isEmpty(), 40024);
        return this.keys.iterator().next();
    }

    @Deprecated
    public final Key findKey(String keyId) {
        return this.getKeyById(keyId);
    }

    public final Key getKey(String keyId) {
        return this.getKeyById(keyId);
    }

    private Key getKeyById(String keyId) {
        Key key = null;
        for (Key keyIt : this.keys) {
            if (!keyId.equals(keyIt.getId())) continue;
            key = keyIt;
            break;
        }
        return key;
    }

    public final IonicError getError(String id) {
        IonicError error = null;
        for (IonicError errorIt : this.errors) {
            if (!id.equals(errorIt.getKeyId())) continue;
            error = errorIt;
            break;
        }
        return error;
    }

    public final QueryResult getQueryResult(String id) {
        QueryResult result = null;
        for (QueryResult resultIt : this.results) {
            if (!id.equals(resultIt.getKeyId())) continue;
            result = resultIt;
            break;
        }
        return result;
    }

    public final void add(Key key) {
        this.keys.add(key);
    }

    public final void add(IonicError error) {
        this.errors.add(error);
    }

    public final void add(QueryResult result) {
        this.results.add(result);
    }

    public static class QueryResult
    implements Serializable {
        private String keyId;
        private List<String> mappedIdList;
        private int errorCode;
        private String errorMessage;
        private static final long serialVersionUID = 6680563312476596034L;

        public QueryResult(String keyId, int errorCode, String errorMessage) {
            this.keyId = keyId;
            this.errorCode = errorCode;
            this.errorMessage = errorMessage;
            this.mappedIdList = new ArrayList<String>();
        }

        public QueryResult(String keyId, List<String> mappedIdList) {
            this.keyId = keyId;
            this.errorCode = 0;
            this.errorMessage = null;
            ArrayList mappedIdListSafe = mappedIdList == null ? new ArrayList() : mappedIdList;
            this.mappedIdList = new ArrayList<String>(mappedIdListSafe);
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final List<String> getMappedIds() {
            return this.mappedIdList;
        }

        public final void setMappedIds(List<String> mappedIdList) {
            ArrayList mappedIdListSafe = mappedIdList == null ? new ArrayList() : mappedIdList;
            this.mappedIdList = new ArrayList<String>(mappedIdListSafe);
        }

        public final int getErrorCode() {
            return this.errorCode;
        }

        public final void setErrorCode(int errorCode) {
            this.errorCode = errorCode;
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }
    }

    public static class IonicError
    implements Serializable {
        private String keyId;
        private int clientError;
        private int serverError;
        private String serverMessage;
        private static final long serialVersionUID = 874472719891645740L;

        public IonicError(String keyId, int clientError, int serverError, String serverMessage) {
            this.keyId = keyId;
            this.clientError = clientError;
            this.serverError = serverError;
            this.serverMessage = serverMessage;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final int getClientError() {
            return this.clientError;
        }

        public final void setClientError(int clientError) {
            this.clientError = clientError;
        }

        public final int getServerError() {
            return this.serverError;
        }

        public final void setServerError(int serverError) {
            this.serverError = serverError;
        }

        public final String getServerMessage() {
            return this.serverMessage;
        }

        public final void setServerMessage(String serverMessage) {
            this.serverMessage = serverMessage;
        }
    }

    public static class Key
    extends AgentKey {
        private String deviceId;
        private static final long serialVersionUID = 7596297196036949557L;

        public Key() {
            this("", new byte[0], null, new KeyAttributesMap(), new KeyAttributesMap(), new KeyObligationsMap(), "", "", "");
        }

        public Key(String id, byte[] key, String deviceId) {
            this(id, key, deviceId, new KeyAttributesMap(), new KeyAttributesMap(), new KeyObligationsMap(), "", "", "");
        }

        public Key(String id, byte[] key, KeyAttributesMap attributes, KeyAttributesMap mutableAttributes) {
            this(id, key, null, attributes, mutableAttributes, new KeyObligationsMap(), "", "", "");
        }

        public Key(String id, byte[] key, String deviceId, KeyAttributesMap attributes, KeyAttributesMap mutableAttributes, KeyObligationsMap keyObligations, String origin) {
            this(id, key, deviceId, attributes, mutableAttributes, keyObligations, origin, null, null);
        }

        public Key(String id, byte[] key, String deviceId, KeyAttributesMap attributes, KeyAttributesMap mutableAttributes, KeyObligationsMap obligations, String origin, String attributesSig, String mutableAttributesSig) {
            this.setId(id);
            this.setKey(key);
            this.deviceId = Value.defaultOnEmpty(deviceId, "");
            this.setAttributesMap(attributes);
            this.setMutableAttributesMap(mutableAttributes);
            this.setMutableAttributesMapFromServer(mutableAttributes);
            this.setObligationsMap(obligations);
            this.setOrigin(Value.defaultOnEmpty(origin, ""));
            this.setAttributesSigBase64FromServer(attributesSig);
            this.setMutableAttributesSigBase64FromServer(mutableAttributesSig);
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = Value.defaultOnEmpty(deviceId, "");
        }
    }
}

