/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.request.getkey;

import com.ionic.sdk.agent.ServiceProtocol;
import com.ionic.sdk.agent.key.KeyAttributesMap;
import com.ionic.sdk.agent.key.KeyObligationsMap;
import com.ionic.sdk.agent.request.base.AgentRequestBase;
import com.ionic.sdk.agent.request.base.AgentResponseBase;
import com.ionic.sdk.agent.request.base.AgentTransactionBase;
import com.ionic.sdk.agent.request.getkey.GetKeysMessage;
import com.ionic.sdk.agent.request.getkey.GetKeysRequest;
import com.ionic.sdk.agent.request.getkey.GetKeysResponse;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.httpclient.HttpRequest;
import com.ionic.sdk.httpclient.HttpResponse;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonSource;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;

@InternalUseOnly
public class GetKeysTransaction
extends AgentTransactionBase {
    private GetKeysMessage message = null;

    public GetKeysTransaction(ServiceProtocol protocol, AgentRequestBase requestBase, AgentResponseBase responseBase) {
        super(protocol, requestBase, responseBase);
    }

    @Override
    protected final HttpRequest buildHttpRequest(Properties fingerprint) throws IonicException {
        AgentRequestBase agentRequestBase = this.getRequestBase();
        SdkData.checkTrue(agentRequestBase instanceof GetKeysRequest, 40001);
        GetKeysRequest request = (GetKeysRequest)agentRequestBase;
        List<String> externalIds = request.getExternalIds();
        List<String> keyIds = request.getKeyIds();
        if (externalIds.isEmpty() && keyIds.isEmpty()) {
            throw new IonicException(40014, "No key ids or external ids in get key request.");
        }
        this.message = new GetKeysMessage(this.getProtocol());
        JsonObject jsonMessage = this.message.getJsonMessage(request, fingerprint);
        String resource = this.getProtocol().getResource("v2.4", "/keys/fetch");
        byte[] envelope = Transcoder.utf8().decode(JsonIO.write(jsonMessage, false));
        byte[] envelopeSecure = this.getProtocol().transformRequestPayload(envelope, this.message.getCid());
        ByteArrayInputStream bis = new ByteArrayInputStream(envelopeSecure);
        return new HttpRequest(this.getProtocol().getUrl(), "POST", resource, this.getHttpHeaders(), bis);
    }

    @Override
    protected final void parseHttpResponse(HttpRequest httpRequest, HttpResponse httpResponse) throws IonicException {
        JsonObject jsonQueries;
        this.parseHttpResponseBase(httpRequest, httpResponse, this.message.getCid());
        AgentResponseBase agentResponseBase = this.getResponseBase();
        SdkData.checkTrue(agentResponseBase instanceof GetKeysResponse, 40001);
        GetKeysResponse response = (GetKeysResponse)agentResponseBase;
        String cid = response.getConversationId();
        JsonObject jsonPayload = response.getJsonPayload();
        JsonObject jsonData = JsonSource.getJsonObject(jsonPayload, "data");
        JsonArray jsonProtectionKeys = JsonSource.getJsonArray(jsonData, "protection-keys");
        for (JsonValue value : jsonProtectionKeys) {
            JsonObject jsonProtectionKey = JsonSource.toJsonObject(value, "protection-keys");
            String id = JsonSource.getString(jsonProtectionKey, "id");
            String keyHex = JsonSource.getString(jsonProtectionKey, "key");
            String cattrs = JsonSource.getString(jsonProtectionKey, "cattrs");
            String mattrs = JsonSource.getString(jsonProtectionKey, "mattrs");
            String csig = JsonSource.getString(jsonProtectionKey, "csig");
            String msig = JsonSource.getString(jsonProtectionKey, "msig");
            String authData = Value.join(":", cid, id, csig, msig);
            byte[] clearBytesKey = this.getProtocol().getKeyBytes(keyHex, authData);
            this.getProtocol().verifySignature("csig", csig, cattrs, clearBytesKey);
            this.getProtocol().verifySignature("msig", msig, mattrs, clearBytesKey);
            KeyAttributesMap cattrsKey = this.message.getJsonAttrs(cattrs, id, clearBytesKey);
            KeyAttributesMap mattrsKey = this.message.getJsonAttrs(mattrs, id, clearBytesKey);
            response.add(new GetKeysResponse.Key(id, clearBytesKey, this.getProtocol().getIdentity(), cattrsKey, mattrsKey, new KeyObligationsMap(), "ionic-keyserver", csig, msig));
        }
        JsonObject jsonErrors = JsonSource.getJsonObjectNullable(jsonData, "errorMap");
        if (jsonErrors != null) {
            Iterator<Map.Entry<String, JsonValue>> iterator = JsonSource.getIterator(jsonErrors);
            while (iterator.hasNext()) {
                Map.Entry<String, JsonValue> entry = iterator.next();
                String keyId = entry.getKey();
                JsonObject error = JsonSource.toJsonObject(entry.getValue(), "errorMap");
                int serverCode = JsonSource.getInt(error, "code");
                String serverMessage = JsonSource.getString(error, "message");
                response.add(new GetKeysResponse.IonicError(keyId, 0, serverCode, serverMessage));
            }
        }
        if ((jsonQueries = JsonSource.getJsonObjectNullable(jsonData, "query-results")) != null) {
            AgentRequestBase agentRequestBase = this.getRequestBase();
            SdkData.checkTrue(agentRequestBase instanceof GetKeysRequest, 40001);
            GetKeysRequest request = (GetKeysRequest)agentRequestBase;
            for (String extId : request.getExternalIds()) {
                JsonObject errorObj;
                JsonObject queryResult = JsonSource.getJsonObject(jsonQueries, extId);
                JsonArray keyArray = JsonSource.getJsonArrayNullable(queryResult, "ids");
                if (keyArray != null) {
                    ArrayList<String> values = new ArrayList<String>();
                    for (JsonValue jsonValue : keyArray) {
                        values.add(JsonSource.toString(jsonValue));
                    }
                    response.add(new GetKeysResponse.QueryResult(extId, values));
                }
                if ((errorObj = JsonSource.getJsonObjectNullable(queryResult, "error")) == null) continue;
                int errorCode = JsonSource.getInt(errorObj, "code");
                String errorMessage = JsonSource.getString(errorObj, "message");
                response.add(new GetKeysResponse.QueryResult(extId, errorCode, errorMessage));
            }
        }
    }
}

