/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.request.getkeyspace;

import com.ionic.sdk.agent.ServiceProtocol;
import com.ionic.sdk.agent.request.base.AgentRequestBase;
import com.ionic.sdk.agent.request.base.AgentResponseBase;
import com.ionic.sdk.agent.request.base.AgentTransactionBase;
import com.ionic.sdk.agent.request.getkeyspace.GetKeyspaceRequest;
import com.ionic.sdk.agent.request.getkeyspace.GetKeyspaceResponse;
import com.ionic.sdk.agent.transaction.AgentTransactionUtil;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.device.DeviceUtils;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.httpclient.HttpRequest;
import com.ionic.sdk.httpclient.HttpResponse;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonSource;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Logger;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

@InternalUseOnly
public class GetKeyspaceTransaction
extends AgentTransactionBase {
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    public GetKeyspaceTransaction(ServiceProtocol protocol, AgentRequestBase requestBase, AgentResponseBase responseBase) {
        super(protocol, requestBase, responseBase);
    }

    @Override
    protected final HttpRequest buildHttpRequest(Properties fingerprint) throws IonicException {
        AgentRequestBase agentRequestBase = this.getRequestBase();
        SdkData.checkTrue(agentRequestBase instanceof GetKeyspaceRequest, 40001);
        GetKeyspaceRequest request = (GetKeyspaceRequest)agentRequestBase;
        URL url = AgentTransactionUtil.getProfileUrl(request.getUrl());
        String resource = String.format("/%s/kns/keyspaces/%s", "v2.4", request.getKeyspace());
        return new HttpRequest(url, "GET", resource);
    }

    @Override
    protected final void parseHttpResponse(HttpRequest httpRequest, HttpResponse httpResponse) throws IonicException {
        byte[] payload = DeviceUtils.read(httpResponse.getEntity());
        String contentType = httpResponse.getHttpHeaders().getHeaderValue("Content-Type");
        SdkData.checkTrue("application/json".equals(contentType), 40015, contentType);
        try {
            JsonObject jsonPayload = JsonIO.readObject(payload);
            this.parseHttpResponsePayload(jsonPayload);
        }
        catch (IonicException e) {
            throw new IonicException(40015, (Throwable)e);
        }
    }

    private void parseHttpResponsePayload(JsonObject jsonPayload) throws IonicException {
        AgentRequestBase agentRequestBase = this.getRequestBase();
        AgentResponseBase agentResponseBase = this.getResponseBase();
        SdkData.checkTrue(agentRequestBase instanceof GetKeyspaceRequest, 40001);
        SdkData.checkTrue(agentResponseBase instanceof GetKeyspaceResponse, 40001);
        GetKeyspaceRequest request = (GetKeyspaceRequest)agentRequestBase;
        GetKeyspaceResponse response = (GetKeyspaceResponse)agentResponseBase;
        response.setKeyspace(JsonSource.getJsonString(jsonPayload, "keyspace").getString());
        response.setFqdn(JsonSource.getJsonString(jsonPayload, "fqdn").getString());
        response.setTtlSeconds(JsonSource.getJsonNumber(jsonPayload, "ttlSeconds").intValue());
        JsonObject jsonAnswers = JsonSource.getJsonObject(jsonPayload, "answers");
        JsonArray jsonEnroll = JsonSource.getJsonArray(jsonAnswers, "enroll");
        for (Object jsonValue : jsonEnroll) {
            JsonString jsonString = (JsonString)jsonValue;
            response.getEnrollmentURLs().add(JsonSource.toString((JsonValue)jsonString));
        }
        JsonArray jsonTenantId = JsonSource.getJsonArray(jsonAnswers, "tenantid");
        for (JsonValue jsonValue : jsonTenantId) {
            JsonString jsonString = (JsonString)jsonValue;
            response.getTenantIDs().add(JsonSource.toString((JsonValue)jsonString));
        }
        JsonArray jsonURL = JsonSource.getJsonArrayNullable(jsonAnswers, "url");
        if (jsonURL != null) {
            for (JsonValue jsonValue : jsonURL) {
                JsonString jsonString = (JsonString)jsonValue;
                response.getApiURLs().add(JsonSource.toString((JsonValue)jsonString));
            }
        }
        if (response.getApiURLs().isEmpty()) {
            this.logger.warning(String.format("No API URLs received from server '%s'.", request.getUrl()));
        }
    }

    @Override
    protected final boolean isIdentityNeeded() {
        return false;
    }
}

