/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.request.getresources;

import com.ionic.sdk.agent.ServiceProtocol;
import com.ionic.sdk.agent.request.base.AgentRequestBase;
import com.ionic.sdk.agent.request.base.AgentResponseBase;
import com.ionic.sdk.agent.request.base.AgentTransactionBase;
import com.ionic.sdk.agent.request.getresources.GetResourcesMessage;
import com.ionic.sdk.agent.request.getresources.GetResourcesRequest;
import com.ionic.sdk.agent.request.getresources.GetResourcesResponse;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.httpclient.HttpRequest;
import com.ionic.sdk.httpclient.HttpResponse;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonSource;
import java.io.ByteArrayInputStream;
import java.util.Properties;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;

@InternalUseOnly
public class GetResourcesTransaction
extends AgentTransactionBase {
    private GetResourcesMessage message = null;

    public GetResourcesTransaction(ServiceProtocol protocol, AgentRequestBase requestBase, AgentResponseBase responseBase) {
        super(protocol, requestBase, responseBase);
    }

    @Override
    protected final HttpRequest buildHttpRequest(Properties fingerprint) throws IonicException {
        this.message = new GetResourcesMessage(this.getProtocol());
        AgentRequestBase agentRequestBase = this.getRequestBase();
        SdkData.checkTrue(agentRequestBase instanceof GetResourcesRequest, 40001);
        GetResourcesRequest request = (GetResourcesRequest)agentRequestBase;
        JsonObject jsonMessage = this.message.getJsonMessage(request, fingerprint);
        String resource = String.format("/%s/resources", "v2.4");
        byte[] envelope = Transcoder.utf8().decode(JsonIO.write(jsonMessage, false));
        byte[] envelopeSecure = this.getProtocol().transformRequestPayload(envelope, this.message.getCid());
        ByteArrayInputStream bis = new ByteArrayInputStream(envelopeSecure);
        return new HttpRequest(this.getProtocol().getUrl(), "POST", resource, this.getHttpHeaders(), bis);
    }

    @Override
    protected final void parseHttpResponse(HttpRequest httpRequest, HttpResponse httpResponse) throws IonicException {
        this.parseHttpResponseBase(httpRequest, httpResponse, this.message.getCid());
        AgentResponseBase agentResponseBase = this.getResponseBase();
        SdkData.checkTrue(agentResponseBase instanceof GetResourcesResponse, 40001);
        GetResourcesResponse response = (GetResourcesResponse)agentResponseBase;
        JsonObject jsonPayload = response.getJsonPayload();
        JsonObject jsonData = JsonSource.getJsonObject(jsonPayload, "data");
        JsonArray jsonResponses = JsonSource.getJsonArray(jsonData, "responses");
        for (JsonValue value : jsonResponses) {
            JsonObject jsonResponse = JsonSource.toJsonObject(value, "responses");
            String id = JsonSource.getString(jsonResponse, "id");
            String data = JsonSource.getString(jsonResponse, "data");
            String error = JsonSource.getString(jsonResponse, "error");
            response.add(new GetResourcesResponse.Resource(id, data, error));
        }
    }
}

