/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.request.logmessage;

import com.ionic.sdk.agent.ServiceProtocol;
import com.ionic.sdk.agent.request.base.AgentRequestBase;
import com.ionic.sdk.agent.request.base.MessageBase;
import com.ionic.sdk.agent.request.logmessage.LogMessagesRequest;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.error.SdkError;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonTarget;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class LogMessagesMessage
extends MessageBase {
    LogMessagesMessage(ServiceProtocol protocol) throws IonicException {
        super(protocol);
    }

    @Override
    protected final JsonValue getJsonData(AgentRequestBase requestBase) throws IonicException {
        JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
        SdkData.checkTrue(requestBase instanceof LogMessagesRequest, 40001);
        LogMessagesRequest logMessagesRequest = (LogMessagesRequest)requestBase;
        for (LogMessagesRequest.Message message : logMessagesRequest.getMessages()) {
            JsonTarget.addNotNull(arrayBuilder, (JsonValue)this.getJsonDataOne(message));
        }
        return arrayBuilder.build();
    }

    private JsonObject getJsonDataOne(LogMessagesRequest.Message message) throws IonicException {
        JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
        SdkData.checkTrue(message.getData() != null, 40004, SdkError.getErrorString(40004));
        JsonTarget.addNotNull(objectBuilder, "data", (JsonValue)JsonIO.readObject(message.getData(), 40010));
        JsonTarget.addNotNull(objectBuilder, "message_type", message.getType());
        return objectBuilder.build();
    }
}

