/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.request.logmessage;

import com.ionic.sdk.agent.ServiceProtocol;
import com.ionic.sdk.agent.request.base.AgentRequestBase;
import com.ionic.sdk.agent.request.base.AgentResponseBase;
import com.ionic.sdk.agent.request.base.AgentTransactionBase;
import com.ionic.sdk.agent.request.logmessage.LogMessagesMessage;
import com.ionic.sdk.agent.request.logmessage.LogMessagesRequest;
import com.ionic.sdk.agent.request.logmessage.LogMessagesResponse;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.error.SdkError;
import com.ionic.sdk.httpclient.HttpRequest;
import com.ionic.sdk.httpclient.HttpResponse;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonSource;
import java.io.ByteArrayInputStream;
import java.util.Properties;
import javax.json.JsonObject;

@InternalUseOnly
public class LogMessagesTransaction
extends AgentTransactionBase {
    private LogMessagesMessage message = null;

    public LogMessagesTransaction(ServiceProtocol protocol, AgentRequestBase requestBase, AgentResponseBase responseBase) {
        super(protocol, requestBase, responseBase);
    }

    @Override
    protected final HttpRequest buildHttpRequest(Properties fingerprint) throws IonicException {
        this.message = new LogMessagesMessage(this.getProtocol());
        AgentRequestBase agentRequestBase = this.getRequestBase();
        SdkData.checkTrue(agentRequestBase instanceof LogMessagesRequest, 40001);
        LogMessagesRequest request = (LogMessagesRequest)agentRequestBase;
        JsonObject jsonMessage = this.message.getJsonMessage(request, fingerprint);
        byte[] envelope = Transcoder.utf8().decode(JsonIO.write(jsonMessage, false));
        byte[] envelopeSecure = this.getProtocol().transformRequestPayload(envelope, this.message.getCid());
        String resource = String.format("/%s/messages", "v2.4");
        ByteArrayInputStream bis = new ByteArrayInputStream(envelopeSecure);
        return new HttpRequest(this.getProtocol().getUrl(), "POST", resource, this.getHttpHeaders(), bis);
    }

    @Override
    protected final void parseHttpResponse(HttpRequest httpRequest, HttpResponse httpResponse) throws IonicException {
        this.parseHttpResponseBase(httpRequest, httpResponse, this.message.getCid());
        AgentResponseBase agentResponseBase = this.getResponseBase();
        SdkData.checkTrue(agentResponseBase instanceof LogMessagesResponse, 40001);
        LogMessagesResponse response = (LogMessagesResponse)agentResponseBase;
        JsonObject jsonPayload = response.getJsonPayload();
        SdkData.checkTrue(JsonSource.isSize(jsonPayload, 0), 40005, SdkError.getErrorString(40005));
    }
}

