/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.request.updatekey;

import com.ionic.sdk.agent.ServiceProtocol;
import com.ionic.sdk.agent.request.base.AgentRequestBase;
import com.ionic.sdk.agent.request.base.MessageBase;
import com.ionic.sdk.agent.request.updatekey.UpdateKeysRequest;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonTarget;
import java.util.ArrayList;
import java.util.Properties;
import java.util.TreeSet;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class UpdateKeysMessage
extends MessageBase {
    private final Properties msigs = new Properties();

    UpdateKeysMessage(ServiceProtocol protocol) throws IonicException {
        super(protocol);
    }

    public final Properties getMsigs() {
        return this.msigs;
    }

    protected final JsonObject getJsonData(AgentRequestBase requestBase) throws IonicException {
        SdkData.checkTrue(requestBase instanceof UpdateKeysRequest, 40001);
        UpdateKeysRequest updateKeysRequest = (UpdateKeysRequest)requestBase;
        return Json.createObjectBuilder().add("protection-keys", (JsonValue)this.getJsonProtectionKeys(updateKeysRequest)).build();
    }

    private JsonArray getJsonProtectionKeys(UpdateKeysRequest updateKeysRequest) throws IonicException {
        TreeSet<String> ids = new TreeSet<String>();
        ArrayList<JsonObject> jsonProtectionKeys = new ArrayList<JsonObject>();
        for (UpdateKeysRequest.Key key : updateKeysRequest.getKeys()) {
            JsonObjectBuilder objectBuilder = Json.createObjectBuilder();
            String id = key.getId();
            ids.add(id);
            JsonTarget.addNotNull(objectBuilder, "id", id);
            JsonTarget.add(objectBuilder, "force", key.getForceUpdate());
            String csig = "";
            String prevcsig = key.getForceUpdate() ? "" : key.getAttributesSigBase64FromServer();
            String prevmsig = key.getForceUpdate() ? "" : key.getMutableAttributesSigBase64FromServer();
            JsonTarget.addNotNull(objectBuilder, "csig", "");
            JsonTarget.addNotNull(objectBuilder, "prevcsig", prevcsig);
            JsonTarget.addNotNull(objectBuilder, "prevmsig", prevmsig);
            String extra = key.getForceUpdate() ? "force" : null;
            String mattrs = JsonIO.write(super.generateJsonAttrs(key.getMutableAttributesMap()), false);
            String msig = this.getProtocol().signAttributes(this.getCid(), id, extra, this.msigs, mattrs, true);
            JsonTarget.addNotNull(objectBuilder, "mattrs", mattrs);
            JsonTarget.addNotNull(objectBuilder, "msig", msig);
            JsonObject jsonProtectionKey = objectBuilder.build();
            jsonProtectionKeys.add(jsonProtectionKey);
        }
        SdkData.checkTrue(updateKeysRequest.getKeys().size() == ids.size(), 40032);
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        for (JsonObject jsonProtectionKey : jsonProtectionKeys) {
            JsonTarget.addNotNull(jsonArrayBuilder, (JsonValue)jsonProtectionKey);
        }
        return jsonArrayBuilder.build();
    }
}

