/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.request.updatekey;

import com.ionic.sdk.agent.key.AgentKey;
import com.ionic.sdk.agent.key.KeyAttributesMap;
import com.ionic.sdk.agent.key.KeyObligationsMap;
import com.ionic.sdk.agent.request.base.AgentResponseBase;
import com.ionic.sdk.core.value.Value;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class UpdateKeysResponse
extends AgentResponseBase {
    private final List<Key> keys = new ArrayList<Key>();
    private final List<IonicError> errors = new ArrayList<IonicError>();
    private static final long serialVersionUID = 7416884005935984946L;

    public final List<Key> getKeys() {
        return this.keys;
    }

    public final List<IonicError> getErrors() {
        return this.errors;
    }

    public final void add(Key key) {
        this.keys.add(key);
    }

    public final void add(IonicError error) {
        this.errors.add(error);
    }

    public final Key getKey(String id) {
        Key key = null;
        for (Key keyIt : this.keys) {
            if (!id.equals(keyIt.getId())) continue;
            key = keyIt;
            break;
        }
        return key;
    }

    public final IonicError getError(String id) {
        IonicError error = null;
        for (IonicError errorIt : this.errors) {
            if (!id.equals(errorIt.getKeyId())) continue;
            error = errorIt;
            break;
        }
        return error;
    }

    public static class IonicError
    implements Serializable {
        private String keyId;
        private int clientError;
        private int serverError;
        private String serverMessage;
        private static final long serialVersionUID = -4176159213618554197L;

        public IonicError(String keyId, int clientError, int serverError, String serverMessage) {
            this.keyId = keyId;
            this.clientError = clientError;
            this.serverError = serverError;
            this.serverMessage = serverMessage;
        }

        public final String getKeyId() {
            return this.keyId;
        }

        public final void setKeyId(String keyId) {
            this.keyId = keyId;
        }

        public final int getClientError() {
            return this.clientError;
        }

        public final void setClientError(int clientError) {
            this.clientError = clientError;
        }

        public final int getServerError() {
            return this.serverError;
        }

        public final void setServerError(int serverError) {
            this.serverError = serverError;
        }

        public final String getServerMessage() {
            return this.serverMessage;
        }

        public final void setServerMessage(String serverMessage) {
            this.serverMessage = serverMessage;
        }
    }

    public static class Key
    extends AgentKey
    implements Serializable {
        private String deviceId;
        private static final long serialVersionUID = -3431416299803402371L;

        public Key() {
            this.deviceId = "";
            this.setOrigin("");
        }

        public Key(AgentKey agentKey, String deviceId, String origin) {
            super(agentKey);
            this.deviceId = deviceId;
            this.setOrigin(origin);
        }

        public Key(String id, byte[] key, String deviceId) {
            super(id, key);
            this.setDeviceId(deviceId);
        }

        public Key(String id, byte[] key, String deviceId, KeyAttributesMap attributes, KeyAttributesMap mutableAttributes, KeyObligationsMap obligations, String keyOrigin) {
            super(id, key, attributes, mutableAttributes, obligations);
            this.setDeviceId(deviceId);
            this.setOrigin(keyOrigin);
        }

        public Key(String id, byte[] key, String deviceId, KeyAttributesMap attributes, KeyAttributesMap mutableAttributes, KeyObligationsMap obligations, String keyOrigin, String attributesSigBase64FromServer, String mutableAttributesSigBase64FromServer) {
            super(id, key, attributes, mutableAttributes, obligations);
            this.setDeviceId(deviceId);
            this.setOrigin(keyOrigin);
            this.setAttributesSigBase64FromServer(attributesSigBase64FromServer);
            this.setMutableAttributesSigBase64FromServer(mutableAttributesSigBase64FromServer);
        }

        public final String getDeviceId() {
            return this.deviceId;
        }

        public final void setDeviceId(String deviceId) {
            this.deviceId = Value.defaultOnEmpty(deviceId, "");
        }
    }
}

