/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.request.updatekey;

import com.ionic.sdk.agent.ServiceProtocol;
import com.ionic.sdk.agent.request.base.AgentRequestBase;
import com.ionic.sdk.agent.request.base.AgentResponseBase;
import com.ionic.sdk.agent.request.base.AgentTransactionBase;
import com.ionic.sdk.agent.request.updatekey.UpdateKeysMessage;
import com.ionic.sdk.agent.request.updatekey.UpdateKeysRequest;
import com.ionic.sdk.agent.request.updatekey.UpdateKeysResponse;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.IonicServerException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.httpclient.HttpRequest;
import com.ionic.sdk.httpclient.HttpResponse;
import com.ionic.sdk.json.JsonIO;
import com.ionic.sdk.json.JsonSource;
import java.io.ByteArrayInputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;

@InternalUseOnly
public class UpdateKeysTransaction
extends AgentTransactionBase {
    private UpdateKeysMessage message = null;

    public UpdateKeysTransaction(ServiceProtocol protocol, AgentRequestBase requestBase, AgentResponseBase responseBase) {
        super(protocol, requestBase, responseBase);
    }

    @Override
    protected final HttpRequest buildHttpRequest(Properties fingerprint) throws IonicException {
        this.message = new UpdateKeysMessage(this.getProtocol());
        AgentRequestBase agentRequestBase = this.getRequestBase();
        SdkData.checkTrue(agentRequestBase instanceof UpdateKeysRequest, 40001);
        UpdateKeysRequest request = (UpdateKeysRequest)agentRequestBase;
        JsonObject jsonMessage = this.message.getJsonMessage(request, fingerprint);
        String resource = String.format("/%s/keys/modify", "v2.4");
        byte[] envelope = Transcoder.utf8().decode(JsonIO.write(jsonMessage, false));
        byte[] envelopeSecure = this.getProtocol().transformRequestPayload(envelope, this.message.getCid());
        ByteArrayInputStream bis = new ByteArrayInputStream(envelopeSecure);
        return new HttpRequest(this.getProtocol().getUrl(), "POST", resource, this.getHttpHeaders(), bis);
    }

    @Override
    protected final void parseHttpResponse(HttpRequest httpRequest, HttpResponse httpResponse) throws IonicException {
        this.parseHttpResponseBase(httpRequest, httpResponse, this.message.getCid());
        AgentRequestBase agentRequestBase = this.getRequestBase();
        AgentResponseBase agentResponseBase = this.getResponseBase();
        SdkData.checkTrue(agentRequestBase instanceof UpdateKeysRequest, 40001);
        SdkData.checkTrue(agentResponseBase instanceof UpdateKeysResponse, 40001);
        UpdateKeysRequest request = (UpdateKeysRequest)agentRequestBase;
        UpdateKeysResponse response = (UpdateKeysResponse)agentResponseBase;
        JsonObject jsonPayload = response.getJsonPayload();
        JsonObject jsonData = JsonSource.getJsonObject(jsonPayload, "data");
        JsonArray jsonProtectionKeys = JsonSource.getJsonArray(jsonData, "protection-keys");
        for (JsonValue value : jsonProtectionKeys) {
            JsonObject jsonProtectionKey = JsonSource.toJsonObject(value, "protection-keys");
            String id = JsonSource.getString(jsonProtectionKey, "id");
            UpdateKeysRequest.Key keyQ = request.getKey(id);
            String csigQ = "";
            String msigQ = this.message.getMsigs().getProperty(id, "");
            String prevcsig = keyQ.getForceUpdate() ? "" : keyQ.getAttributesSigBase64FromServer();
            String prevmsig = keyQ.getForceUpdate() ? "" : keyQ.getMutableAttributesSigBase64FromServer();
            String csig = JsonSource.getString(jsonProtectionKey, "csig");
            String msig = JsonSource.getString(jsonProtectionKey, "msig");
            String sigs = JsonSource.getString(jsonProtectionKey, "sigs");
            String macR = Value.join(",", prevcsig, "", prevmsig, msigQ);
            String mac = Value.join(":", keyQ.getId(), macR);
            this.getProtocol().verifySignature("sigs", sigs, mac, null);
            UpdateKeysResponse.Key keyA = new UpdateKeysResponse.Key(keyQ, this.getProtocol().getIdentity(), "ionic-keyserver");
            keyA.setAttributesSigBase64FromServer(csig);
            keyA.setMutableAttributesSigBase64FromServer(msig);
            response.add(keyA);
        }
        JsonObject jsonErrors = JsonSource.getJsonObjectNullable(jsonData, "errorMap");
        if (jsonErrors != null) {
            Iterator<Map.Entry<String, JsonValue>> iterator = JsonSource.getIterator(jsonErrors);
            while (iterator.hasNext()) {
                Map.Entry<String, JsonValue> entry = iterator.next();
                String keyId = entry.getKey();
                JsonObject error = JsonSource.toJsonObject(entry.getValue(), "errorMap");
                int serverCode = JsonSource.getInt(error, "code");
                String serverMessage = JsonSource.getString(error, "message");
                response.add(new UpdateKeysResponse.IonicError(keyId, 0, serverCode, serverMessage));
            }
        }
        if (JsonSource.isSize(jsonProtectionKeys, 0) && jsonErrors != null) {
            throw new IonicException(40009, (Throwable)new IonicServerException(40031, this.message.getCid(), response));
        }
    }
}

