/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.agent.transaction;

import com.ionic.sdk.agent.SdkVersion;
import com.ionic.sdk.agent.ServiceProtocol;
import com.ionic.sdk.agent.request.base.AgentRequestBase;
import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.rng.CryptoRng;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.core.vm.VM;
import com.ionic.sdk.device.profile.DeviceProfile;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import com.ionic.sdk.error.SdkError;
import com.ionic.sdk.json.JsonTarget;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

@InternalUseOnly
public final class AgentTransactionUtil {
    private AgentTransactionUtil() {
    }

    public static DeviceProfile getProfileForKeyId(List<DeviceProfile> deviceProfiles, String keyId) {
        DeviceProfile deviceProfile = null;
        for (DeviceProfile deviceProfileIt : deviceProfiles) {
            String keySpace = deviceProfileIt.getKeySpace();
            if (keyId == null || keySpace.length() >= keyId.length() || !keyId.startsWith(keySpace)) continue;
            if (deviceProfile == null) {
                deviceProfile = deviceProfileIt;
                continue;
            }
            if (deviceProfile.getCreationTimestampSecs() >= deviceProfileIt.getCreationTimestampSecs()) continue;
            deviceProfile = deviceProfileIt;
        }
        return deviceProfile;
    }

    public static String generateConversationId(DeviceProfile activeProfile, String extra) throws IonicException {
        SdkData.checkNotNull(activeProfile, DeviceProfile.class.getName());
        String deviceId = activeProfile.getDeviceId();
        SdkData.checkNotNull(deviceId, "deviceID");
        String date = Long.toString(new Date().getTime());
        byte[] bytes = new CryptoRng().rand(new byte[4]);
        String nonce = Transcoder.base64().encode(bytes).replace("=", "");
        return Value.join("|", "CID", deviceId, date, nonce, extra);
    }

    public static boolean isHttpErrorCode(int statusCode) {
        return statusCode < 200 || statusCode >= 300;
    }

    public static boolean isHttpSuccessCode(int statusCode) {
        return statusCode >= 200 && statusCode < 300;
    }

    public static URL getProfileUrl(DeviceProfile deviceProfile) throws IonicException {
        SdkData.checkNotNull(deviceProfile, DeviceProfile.class.getName());
        return AgentTransactionUtil.getProfileUrlInternal(deviceProfile.getServer());
    }

    public static URL getProfileUrl(String server) throws IonicException {
        return AgentTransactionUtil.getProfileUrlInternal(server);
    }

    private static URL getProfileUrlInternal(String server) throws IonicException {
        try {
            return new URL(server);
        }
        catch (NullPointerException e) {
            throw new IonicException(40021, (Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new IonicException(40005, (Throwable)e);
        }
    }

    public static JsonObject buildStandardJsonMeta(ServiceProtocol protocol, AgentRequestBase requestBase, Properties fingerprint) {
        JsonObjectBuilder builderMeta = Json.createObjectBuilder();
        for (Map.Entry entry : protocol.getMetadata().entrySet()) {
            JsonTarget.addNotNull(builderMeta, (String)entry.getKey(), (String)entry.getValue());
        }
        for (Map.Entry entry : requestBase.getMetadata().entrySet()) {
            JsonTarget.addNotNull(builderMeta, (String)entry.getKey(), (String)entry.getValue());
        }
        for (String key : fingerprint.stringPropertyNames()) {
            JsonTarget.addNotNull(builderMeta, key, fingerprint.getProperty(key));
        }
        JsonTarget.addNotNull(builderMeta, "ionic-agent", SdkVersion.getAgentString());
        JsonTarget.addNotNull(builderMeta, "ionic-user-agent", protocol.getConfig().getUserAgent());
        JsonTarget.addNotNull(builderMeta, "ionic-os-arch", System.getProperty("os.arch"));
        JsonTarget.addNotNull(builderMeta, "ionic-os-name", System.getProperty("os.name"));
        JsonTarget.addNotNull(builderMeta, "ionic-os-version", System.getProperty("os.version"));
        return builderMeta.build();
    }

    public static void checkEqual(String cid, String expected, String actual) throws IonicException {
        if (!Value.isEqual(expected, actual)) {
            int error = 40005;
            throw new IonicException(40005, Value.join(VM.getEol(), SdkError.getErrorString(40005), String.format("Expectation failed (conversation ID %s expected %s, actual %s).", cid, expected, actual)));
        }
    }

    public static void checkNotNull(String cid, String name, String value) throws IonicException {
        if (value == null) {
            int error = 40005;
            throw new IonicException(40005, Value.join(VM.getEol(), SdkError.getErrorString(40005), String.format("Null value detected (conversation ID %s, name %s).", cid, name)));
        }
    }
}

