/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.cipher;

import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.crypto.CryptoUtils;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;

public abstract class CipherAbstract {
    private final Cipher cipherInstance;
    private Key keyInstance;

    public CipherAbstract(Cipher cipher) {
        this.cipherInstance = cipher;
    }

    public abstract String getId();

    public abstract String getLabel();

    protected final void setKeyNative(Key key) {
        this.keyInstance = key;
    }

    public abstract byte[] encrypt(byte[] var1) throws IonicException;

    public abstract byte[] encrypt(String var1) throws IonicException;

    public final String encryptToBase64(byte[] plainText) throws IonicException {
        return CryptoUtils.binToBase64(this.encrypt(plainText));
    }

    public final byte[] encryptString(String plainText) throws IonicException {
        return this.encrypt(Transcoder.utf8().decode(plainText));
    }

    public final String encryptToBase64(String plainText) throws IonicException {
        return CryptoUtils.binToBase64(this.encrypt(Transcoder.utf8().decode(plainText)));
    }

    public abstract byte[] decrypt(byte[] var1) throws IonicException;

    public final String decryptToString(byte[] cipherText) throws IonicException {
        return Transcoder.utf8().encode(this.decrypt(cipherText));
    }

    public final byte[] decryptBase64(String cipherText) throws IonicException {
        return this.decrypt(CryptoUtils.base64ToBin(cipherText));
    }

    public final String decryptBase64ToString(String cipherText) throws IonicException {
        return Transcoder.utf8().encode(this.decrypt(CryptoUtils.base64ToBin(cipherText)));
    }

    protected final byte[] encrypt(byte[] plainText, byte[] authData, AlgorithmParameterSpec parameterSpec) throws IonicException {
        SdkData.checkNotNull(this.keyInstance, Key.class.getName());
        SdkData.checkNotNull(plainText, this.getClass().getSimpleName());
        try {
            return this.encryptInner(plainText, authData, parameterSpec);
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(50001, (Throwable)e);
        }
    }

    private byte[] encryptInner(byte[] plainText, byte[] authData, AlgorithmParameterSpec parameterSpec) throws GeneralSecurityException {
        if (parameterSpec == null) {
            this.cipherInstance.init(1, this.keyInstance);
        } else {
            this.cipherInstance.init(1, this.keyInstance, parameterSpec);
        }
        if (authData != null) {
            this.cipherInstance.updateAAD(authData);
        }
        return this.cipherInstance.doFinal(plainText);
    }

    protected final int encrypt(ByteBuffer plainText, ByteBuffer cipherText, byte[] authData, AlgorithmParameterSpec parameterSpec) throws IonicException {
        SdkData.checkNotNull(this.keyInstance, Key.class.getName());
        SdkData.checkNotNull(plainText, this.getClass().getSimpleName());
        try {
            return this.encryptInner(plainText, cipherText, authData, parameterSpec);
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(50001, (Throwable)e);
        }
    }

    private int encryptInner(ByteBuffer plainText, ByteBuffer cipherText, byte[] authData, AlgorithmParameterSpec parameterSpec) throws GeneralSecurityException {
        if (parameterSpec == null) {
            this.cipherInstance.init(1, this.keyInstance);
        } else {
            this.cipherInstance.init(1, this.keyInstance, parameterSpec);
        }
        if (authData != null) {
            this.cipherInstance.updateAAD(authData);
        }
        return this.cipherInstance.doFinal(plainText, cipherText);
    }

    protected final byte[] decrypt(byte[] cipherText, byte[] authData, AlgorithmParameterSpec parameterSpec) throws IonicException {
        SdkData.checkNotNull(this.keyInstance, Key.class.getName());
        SdkData.checkNotNull(cipherText, this.getClass().getSimpleName());
        try {
            return this.decryptInner(cipherText, authData, parameterSpec);
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(50001, (Throwable)e);
        }
    }

    private byte[] decryptInner(byte[] cipherText, byte[] authData, AlgorithmParameterSpec parameterSpec) throws GeneralSecurityException {
        if (parameterSpec == null) {
            this.cipherInstance.init(2, this.keyInstance);
        } else {
            this.cipherInstance.init(2, this.keyInstance, parameterSpec);
        }
        if (authData != null) {
            this.cipherInstance.updateAAD(authData);
        }
        int inputLen = cipherText.length - 16;
        return this.cipherInstance.doFinal(cipherText, 16, inputLen);
    }

    protected final int decrypt(ByteBuffer plainText, ByteBuffer cipherText, byte[] authData, AlgorithmParameterSpec parameterSpec) throws IonicException {
        SdkData.checkNotNull(this.keyInstance, Key.class.getName());
        SdkData.checkNotNull(plainText, this.getClass().getSimpleName());
        SdkData.checkNotNull(cipherText, this.getClass().getSimpleName());
        try {
            return this.decryptInner(plainText, cipherText, authData, parameterSpec);
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(50001, (Throwable)e);
        }
    }

    private int decryptInner(ByteBuffer plainText, ByteBuffer cipherText, byte[] authData, AlgorithmParameterSpec parameterSpec) throws GeneralSecurityException {
        if (parameterSpec == null) {
            this.cipherInstance.init(2, this.keyInstance);
        } else {
            this.cipherInstance.init(2, this.keyInstance, parameterSpec);
        }
        if (authData != null) {
            this.cipherInstance.updateAAD(authData);
        }
        return this.cipherInstance.doFinal(cipherText, plainText);
    }
}

