/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.cipher.aes;

import com.ionic.sdk.cipher.CipherAbstract;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public abstract class AesCipherAbstract
extends CipherAbstract {
    public AesCipherAbstract(Cipher cipher) {
        super(cipher);
    }

    public final void setKey(byte[] cipherKey) {
        if (!Value.isEmpty(cipherKey)) {
            this.setKeyNative(new SecretKeySpec(cipherKey, "AES"));
        }
    }

    public final void setKey(SecretKey secretKey) throws IonicException {
        SdkData.checkNotNull(secretKey, SecretKey.class.getName());
        this.setKeyNative(secretKey);
    }

    public final void setKeyHex(String cipherKey) {
        if (!Value.isEmpty(cipherKey)) {
            this.setKeyNative(new SecretKeySpec(Transcoder.hex().decode(cipherKey), "AES"));
        }
    }

    public static int getCipherKeyLen() {
        return 32;
    }
}

