/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.cipher.aes;

import com.ionic.sdk.agent.AgentSdk;
import com.ionic.sdk.cipher.aes.AesCipherAbstract;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.rng.CryptoRng;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public class AesCtrCipher
extends AesCipherAbstract {
    private static final String ID = "aes_ctr";
    private static final String LABEL = "AES CTR Cipher";
    private static final String ERR_LABEL = AesCtrCipher.class.getSimpleName();

    public AesCtrCipher() throws IonicException {
        this((byte[])null);
    }

    public AesCtrCipher(byte[] cipherKey) throws IonicException {
        super(AesCtrCipher.getCipherInstance());
        this.setKey(cipherKey);
    }

    public AesCtrCipher(SecretKey secretKey) throws IonicException {
        super(AesCtrCipher.getCipherInstance());
        this.setKey(secretKey);
    }

    private static Cipher getCipherInstance() throws IonicException {
        return AgentSdk.getCrypto().getCipherAesCtr();
    }

    @Override
    public final String getId() {
        return ID;
    }

    @Override
    public final String getLabel() {
        return LABEL;
    }

    @Override
    public final byte[] encrypt(byte[] plainText) throws IonicException {
        return this.encryptInternal(plainText);
    }

    @Override
    public final byte[] encrypt(String plainText) throws IonicException {
        return this.encryptInternal(Transcoder.utf8().decode(plainText));
    }

    private byte[] encryptInternal(byte[] plainText) throws IonicException {
        SdkData.checkNotNull(plainText, ERR_LABEL);
        byte[] iv = new CryptoRng().rand(new byte[16]);
        IvParameterSpec parameterSpec = new IvParameterSpec(iv);
        byte[] cipherText = super.encrypt(plainText, null, parameterSpec);
        byte[] cipherTextIonic = Arrays.copyOf(iv, iv.length + cipherText.length);
        System.arraycopy(cipherText, 0, cipherTextIonic, iv.length, cipherText.length);
        return cipherTextIonic;
    }

    public final int encrypt(ByteBuffer plainText, ByteBuffer cipherText) throws IonicException {
        SdkData.checkNotNull(plainText, ERR_LABEL);
        SdkData.checkNotNull(cipherText, ERR_LABEL);
        byte[] iv = new CryptoRng().rand(new byte[16]);
        IvParameterSpec parameterSpec = new IvParameterSpec(iv);
        cipherText.clear();
        cipherText.put(iv);
        return iv.length + super.encrypt(plainText, cipherText, null, parameterSpec);
    }

    public final int encrypt(ByteBuffer plainText, ByteBuffer cipherText, IvParameterSpec parameterSpec) throws IonicException {
        SdkData.checkNotNull(plainText, ERR_LABEL);
        SdkData.checkNotNull(cipherText, ERR_LABEL);
        SdkData.checkNotNull(parameterSpec, ERR_LABEL);
        cipherText.clear();
        return super.encrypt(plainText, cipherText, null, parameterSpec);
    }

    @Override
    public final byte[] decrypt(byte[] cipherText) throws IonicException {
        SdkData.checkNotNull(cipherText, ERR_LABEL);
        IvParameterSpec parameterSpec = new IvParameterSpec(cipherText, 0, 16);
        return super.decrypt(cipherText, null, parameterSpec);
    }

    public final int decrypt(ByteBuffer plainText, ByteBuffer cipherText) throws IonicException {
        SdkData.checkNotNull(plainText, ERR_LABEL);
        SdkData.checkNotNull(cipherText, ERR_LABEL);
        byte[] iv = new byte[16];
        cipherText.get(iv);
        IvParameterSpec parameterSpec = new IvParameterSpec(iv, 0, iv.length);
        plainText.clear();
        return super.decrypt(plainText, cipherText, null, parameterSpec);
    }

    public final int decrypt(ByteBuffer plainText, ByteBuffer cipherText, IvParameterSpec parameterSpec) throws IonicException {
        SdkData.checkNotNull(plainText, ERR_LABEL);
        SdkData.checkNotNull(cipherText, ERR_LABEL);
        SdkData.checkNotNull(parameterSpec, ERR_LABEL);
        plainText.clear();
        return super.decrypt(plainText, cipherText, null, parameterSpec);
    }
}

