/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.cipher.aes;

import com.ionic.sdk.agent.AgentSdk;
import com.ionic.sdk.cipher.aes.AesCipherAbstract;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.rng.CryptoRng;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import java.nio.ByteBuffer;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;

public class AesGcmCipher
extends AesCipherAbstract {
    private static final String ID = "aes_gcm";
    private static final String LABEL = "AES GCM Cipher";
    private byte[] authData;
    @Deprecated
    public static final int SIZE_AUTH_TAG = 16;
    private static final String ERR_LABEL = AesGcmCipher.class.getSimpleName();
    private static final String ERR_AAD = "Additional Authenticated Data";

    public AesGcmCipher() throws IonicException {
        this((byte[])null);
    }

    public AesGcmCipher(byte[] cipherKey) throws IonicException {
        super(AesGcmCipher.getCipherInstance());
        this.setKey(cipherKey);
    }

    public AesGcmCipher(SecretKey secretKey) throws IonicException {
        super(AesGcmCipher.getCipherInstance());
        this.setKey(secretKey);
    }

    private static Cipher getCipherInstance() throws IonicException {
        return AgentSdk.getCrypto().getCipherAesGcm();
    }

    @Override
    public final String getId() {
        return ID;
    }

    @Override
    public final String getLabel() {
        return LABEL;
    }

    public final void setAuthData(byte[] authDataIn) {
        this.authData = authDataIn == null ? null : Arrays.copyOf(authDataIn, authDataIn.length);
    }

    @Override
    public final byte[] encrypt(byte[] plainText) throws IonicException {
        return this.encryptInternal(plainText);
    }

    @Override
    public final byte[] encrypt(String plainText) throws IonicException {
        return this.encryptInternal(Transcoder.utf8().decode(plainText));
    }

    private byte[] encryptInternal(byte[] plainText) throws IonicException {
        SdkData.checkNotNull(plainText, ERR_LABEL);
        SdkData.checkTrue(!Value.isEmpty(this.authData), 50004, ERR_AAD);
        byte[] iv = new CryptoRng().rand(new byte[16]);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv);
        byte[] cipherText = super.encrypt(plainText, this.authData, parameterSpec);
        byte[] cipherTextIonic = Arrays.copyOf(iv, iv.length + cipherText.length);
        System.arraycopy(cipherText, 0, cipherTextIonic, iv.length, cipherText.length);
        return cipherTextIonic;
    }

    public final int encrypt(ByteBuffer plainText, ByteBuffer cipherText) throws IonicException {
        SdkData.checkNotNull(plainText, ERR_LABEL);
        SdkData.checkNotNull(cipherText, ERR_LABEL);
        SdkData.checkTrue(!Value.isEmpty(this.authData), 50004, ERR_AAD);
        byte[] iv = new CryptoRng().rand(new byte[16]);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv, 0, 16);
        cipherText.clear();
        cipherText.put(iv);
        return iv.length + super.encrypt(plainText, cipherText, this.authData, parameterSpec);
    }

    public final int encrypt(ByteBuffer plainText, ByteBuffer cipherText, GCMParameterSpec parameterSpec) throws IonicException {
        SdkData.checkNotNull(plainText, ERR_LABEL);
        SdkData.checkNotNull(cipherText, ERR_LABEL);
        SdkData.checkNotNull(parameterSpec, ERR_LABEL);
        SdkData.checkTrue(!Value.isEmpty(this.authData), 50004, ERR_AAD);
        cipherText.clear();
        return super.encrypt(plainText, cipherText, this.authData, parameterSpec);
    }

    @Override
    public final byte[] decrypt(byte[] cipherText) throws IonicException {
        SdkData.checkNotNull(cipherText, ERR_LABEL);
        SdkData.checkTrue(!Value.isEmpty(this.authData), 50004, ERR_AAD);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, cipherText, 0, 16);
        return super.decrypt(cipherText, this.authData, parameterSpec);
    }

    public final int decrypt(ByteBuffer plainText, ByteBuffer cipherText) throws IonicException {
        SdkData.checkNotNull(plainText, ERR_LABEL);
        SdkData.checkNotNull(cipherText, ERR_LABEL);
        SdkData.checkTrue(!Value.isEmpty(this.authData), 50004, ERR_AAD);
        byte[] iv = new byte[16];
        cipherText.get(iv);
        GCMParameterSpec parameterSpec = new GCMParameterSpec(128, iv, 0, 16);
        return super.decrypt(plainText, cipherText, this.authData, parameterSpec);
    }

    public final int decrypt(ByteBuffer plainText, ByteBuffer cipherText, GCMParameterSpec parameterSpec) throws IonicException {
        SdkData.checkNotNull(plainText, ERR_LABEL);
        SdkData.checkNotNull(cipherText, ERR_LABEL);
        SdkData.checkNotNull(parameterSpec, ERR_LABEL);
        SdkData.checkTrue(!Value.isEmpty(this.authData), 50004, ERR_AAD);
        plainText.clear();
        return super.decrypt(plainText, cipherText, this.authData, parameterSpec);
    }
}

