/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.cipher.rsa;

import com.ionic.sdk.agent.AgentSdk;
import com.ionic.sdk.cipher.rsa.model.RsaPrivateKey;
import com.ionic.sdk.cipher.rsa.model.RsaPublicKey;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.crypto.CryptoUtils;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import javax.crypto.Cipher;

public final class RsaCipher {
    private final Cipher cipherInstance = AgentSdk.getCrypto().getCipherRsa();
    private KeyPair keypairInstance = new KeyPair(null, null);
    public static final int KEY_BITS = 3072;
    public static final String ALGORITHM = "RSA";
    public static final String TRANSFORM_ECB = "RSA/ECB/OAEPWITHSHA1ANDMGF1PADDING";
    public static final String SIGNATURE_ALGORITHM = "SHA256withRSA/PSS";

    public void setKeypairInstance(KeyPair keypairInstance) {
        this.keypairInstance = keypairInstance;
    }

    public byte[] encrypt(String plainText) throws IonicException {
        return this.encryptInternal(Transcoder.utf8().decode(plainText));
    }

    public byte[] encrypt(byte[] plainText) throws IonicException {
        return this.encryptInternal(plainText);
    }

    private byte[] encryptInternal(byte[] plainText) throws IonicException {
        try {
            SdkData.checkNotNull(this.keypairInstance, KeyPair.class.getName());
            SdkData.checkNotNull(this.keypairInstance.getPublic(), PublicKey.class.getName());
            SdkData.checkNotNull(plainText, this.getClass().getSimpleName());
            this.cipherInstance.init(1, this.keypairInstance.getPublic());
            return this.cipherInstance.doFinal(plainText);
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(50001, (Throwable)e);
        }
    }

    public byte[] decrypt(byte[] cipherText) throws IonicException {
        return this.decryptInternal(cipherText);
    }

    private byte[] decryptInternal(byte[] cipherText) throws IonicException {
        try {
            SdkData.checkNotNull(this.keypairInstance, KeyPair.class.getName());
            SdkData.checkNotNull(this.keypairInstance.getPrivate(), PrivateKey.class.getName());
            SdkData.checkNotNull(cipherText, this.getClass().getSimpleName());
            this.cipherInstance.init(2, this.keypairInstance.getPrivate());
            return this.cipherInstance.doFinal(cipherText);
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(50001, (Throwable)e);
        }
    }

    public void setPublicKey(RsaPublicKey publicKey) {
        this.keypairInstance = new KeyPair(publicKey.getPublicKey(), this.keypairInstance.getPrivate());
    }

    public void setPrivateKey(RsaPrivateKey privateKey) {
        this.keypairInstance = new KeyPair(this.keypairInstance.getPublic(), privateKey.getPrivateKey());
    }

    public String encryptToBase64(byte[] plainText) throws IonicException {
        return Transcoder.base64().encode(this.encryptInternal(plainText));
    }

    public String encryptToBase64(String plainText) throws IonicException {
        return Transcoder.base64().encode(this.encryptInternal(Transcoder.utf8().decode(plainText)));
    }

    public String decryptBase64ToString(String cipherText) throws IonicException {
        return Transcoder.utf8().encode(this.decryptInternal(Transcoder.base64().decode(cipherText)));
    }

    public String decryptToString(byte[] cipherText) throws IonicException {
        return Transcoder.utf8().encode(this.decryptInternal(cipherText));
    }

    public byte[] decryptBase64(String cipherText) throws IonicException {
        return this.decryptInternal(Transcoder.base64().decode(cipherText));
    }

    public String sign(byte[] text) throws IonicException {
        try {
            SdkData.checkNotNull(text, this.getClass().getSimpleName());
            Signature signature = AgentSdk.getCrypto().getSignatureRsa();
            signature.initSign(this.keypairInstance.getPrivate());
            signature.update(text);
            return CryptoUtils.binToBase64(signature.sign());
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(50001, (Throwable)e);
        }
    }

    public boolean verify(byte[] text, byte[] sig) throws IonicException {
        try {
            SdkData.checkNotNull(text, this.getClass().getSimpleName());
            SdkData.checkNotNull(sig, this.getClass().getSimpleName());
            Signature signature = AgentSdk.getCrypto().getSignatureRsa();
            signature.initVerify(this.keypairInstance.getPublic());
            signature.update(text);
            return signature.verify(sig);
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(50001, (Throwable)e);
        }
    }
}

