/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.cipher.rsa.model;

import com.ionic.sdk.agent.AgentSdk;
import com.ionic.sdk.cipher.rsa.model.RsaKeyHolder;
import com.ionic.sdk.cipher.rsa.model.RsaPrivateKey;
import com.ionic.sdk.cipher.rsa.model.RsaPublicKey;
import com.ionic.sdk.error.IonicException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.RSAPublicKeySpec;

public final class RsaKeyGenerator {
    public RsaKeyGenerator() throws IonicException {
        AgentSdk.initialize();
    }

    public RsaKeyHolder generate(int keySize) throws IonicException {
        KeyPairGenerator keygen = AgentSdk.getCrypto().getKeyPairGeneratorRsa();
        keygen.initialize(keySize);
        return new RsaKeyHolder(keygen.generateKeyPair());
    }

    public RsaPrivateKey generatePrivateKey(long keySize) throws IonicException {
        KeyPairGenerator keygen = AgentSdk.getCrypto().getKeyPairGeneratorRsa();
        keygen.initialize((int)keySize);
        return new RsaPrivateKey(keygen.generateKeyPair().getPrivate());
    }

    public RsaPublicKey generatePublicKey(RsaPrivateKey rsaPrivateKey) throws IonicException {
        PrivateKey privateKey = rsaPrivateKey.getPrivateKey();
        if (privateKey instanceof RSAPrivateCrtKey) {
            return this.generatePublicKeyInternal((RSAPrivateCrtKey)privateKey);
        }
        throw new IonicException(50001, privateKey.getClass().getName());
    }

    private RsaPublicKey generatePublicKeyInternal(RSAPrivateCrtKey privkey) throws IonicException {
        try {
            RSAPublicKeySpec publicKeySpec = new RSAPublicKeySpec(privkey.getModulus(), privkey.getPublicExponent());
            KeyFactory keyFactory = AgentSdk.getCrypto().getKeyFactoryRsa();
            return new RsaPublicKey(keyFactory.generatePublic(publicKeySpec));
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(50001, (Throwable)e);
        }
    }
}

