/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.cipher.rsa.model;

import com.ionic.sdk.agent.AgentSdk;
import com.ionic.sdk.cipher.rsa.model.RsaKeyHolder;
import com.ionic.sdk.cipher.rsa.model.RsaPrivateKey;
import com.ionic.sdk.cipher.rsa.model.RsaPublicKey;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.error.IonicException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;

public final class RsaKeyPersistor {
    public RsaKeyPersistor() throws IonicException {
        AgentSdk.initialize();
    }

    public String toBase64Public(RsaKeyHolder keyHolder) {
        PublicKey publicKey = keyHolder.getPublicKey();
        X509EncodedKeySpec x509KeySpec = publicKey == null ? null : new X509EncodedKeySpec(publicKey.getEncoded());
        return x509KeySpec == null ? null : Transcoder.base64().encode(x509KeySpec.getEncoded());
    }

    public String toBase64Private(RsaKeyHolder keyHolder) {
        PrivateKey privateKey = keyHolder.getPrivateKey();
        PKCS8EncodedKeySpec pkcs8KeySpec = privateKey == null ? null : new PKCS8EncodedKeySpec(privateKey.getEncoded());
        return pkcs8KeySpec == null ? null : Transcoder.base64().encode(pkcs8KeySpec.getEncoded());
    }

    public RsaKeyHolder fromBase64(String base64Public, String base64Private) throws IonicException {
        try {
            KeyFactory keyFactory = AgentSdk.getCrypto().getKeyFactoryRsa();
            PublicKey publicKey = base64Public == null ? null : RsaKeyPersistor.toPublicKey(keyFactory, base64Public);
            PrivateKey privateKey = base64Private == null ? null : RsaKeyPersistor.toPrivateKey(keyFactory, base64Private);
            return new RsaKeyHolder(new KeyPair(publicKey, privateKey));
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(50001, (Throwable)e);
        }
    }

    private static PublicKey toPublicKey(KeyFactory keyFactory, String base64Public) throws InvalidKeySpecException {
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(Transcoder.base64().decode(base64Public));
        return keyFactory.generatePublic(x509KeySpec);
    }

    private static PrivateKey toPrivateKey(KeyFactory keyFactory, String base64Private) throws InvalidKeySpecException {
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(Transcoder.base64().decode(base64Private));
        return keyFactory.generatePrivate(pkcs8KeySpec);
    }

    public byte[] savePrivateKeyDer(RsaPrivateKey rsaPrivateKey) {
        if (rsaPrivateKey == null) {
            return null;
        }
        PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(rsaPrivateKey.getPrivateKey().getEncoded());
        return pkcs8KeySpec.getEncoded();
    }

    public RsaPrivateKey loadPrivateKeyBer(byte[] privateKeyBytes) throws IonicException {
        if (privateKeyBytes == null) {
            return null;
        }
        try {
            KeyFactory keyFactory = AgentSdk.getCrypto().getKeyFactoryRsa();
            PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
            PrivateKey privateKey = keyFactory.generatePrivate(pkcs8KeySpec);
            return new RsaPrivateKey(privateKey);
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(50001, (Throwable)e);
        }
    }

    public byte[] savePublicKeyDer(RsaPublicKey rsaPublicKey) {
        if (rsaPublicKey == null) {
            return null;
        }
        X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(rsaPublicKey.getPublicKey().getEncoded());
        return x509KeySpec.getEncoded();
    }

    public RsaPublicKey loadPublicKeyBer(byte[] publicKeyBytes) throws IonicException {
        if (publicKeyBytes == null) {
            return null;
        }
        try {
            KeyFactory keyFactory = AgentSdk.getCrypto().getKeyFactoryRsa();
            X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(publicKeyBytes);
            PublicKey publicKey = keyFactory.generatePublic(x509KeySpec);
            return new RsaPublicKey(publicKey);
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(50001, (Throwable)e);
        }
    }
}

