/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.cipher.rsa.model;

import com.ionic.sdk.agent.AgentSdk;
import com.ionic.sdk.cipher.rsa.model.RsaPrivateKey;
import com.ionic.sdk.cipher.rsa.model.RsaPublicKey;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;

public final class RsaSignatureProcessor {
    private RsaPublicKey rsaPublicKey;
    private RsaPrivateKey rsaPrivateKey;

    public RsaSignatureProcessor() throws IonicException {
        AgentSdk.initialize();
        this.rsaPublicKey = null;
        this.rsaPrivateKey = null;
    }

    public void setPublicKey(RsaPublicKey publicKey) {
        this.rsaPublicKey = publicKey;
    }

    public void setPrivateKey(RsaPrivateKey privateKey) {
        this.rsaPrivateKey = privateKey;
    }

    public byte[] sign(byte[] data) throws IonicException {
        return this.signInternal(data);
    }

    public byte[] sign(String data) throws IonicException {
        return this.signInternal(Transcoder.utf8().decode(data));
    }

    public void verify(byte[] data, byte[] signature) throws IonicException {
        this.verifyInternal(data, signature);
    }

    public void verify(String data, byte[] signature) throws IonicException {
        this.verifyInternal(Transcoder.utf8().decode(data), signature);
    }

    public String signToBase64(String data) throws IonicException {
        return Transcoder.base64().encode(this.signInternal(Transcoder.utf8().decode(data)));
    }

    public void verifyFromBase64(byte[] data, String signatureBase64) throws IonicException {
        this.verifyInternal(data, Transcoder.base64().decode(signatureBase64));
    }

    public void verifyFromBase64(String data, String signatureBase64) throws IonicException {
        this.verifyInternal(Transcoder.utf8().decode(data), Transcoder.base64().decode(signatureBase64));
    }

    private byte[] signInternal(byte[] data) throws IonicException {
        try {
            Signature spi = AgentSdk.getCrypto().getSignatureRsa();
            SdkData.checkNotNull(this.rsaPrivateKey, RsaPrivateKey.class.getName());
            SdkData.checkNotNull(this.rsaPrivateKey.getPrivateKey(), PrivateKey.class.getName());
            spi.initSign(this.rsaPrivateKey.getPrivateKey());
            spi.update(data);
            return spi.sign();
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(50001, (Throwable)e);
        }
    }

    private void verifyInternal(byte[] data, byte[] signature) throws IonicException {
        try {
            Signature spi = AgentSdk.getCrypto().getSignatureRsa();
            SdkData.checkNotNull(this.rsaPublicKey, RsaPublicKey.class.getName());
            SdkData.checkNotNull(this.rsaPublicKey.getPublicKey(), PublicKey.class.getName());
            spi.initVerify(this.rsaPublicKey.getPublicKey());
            spi.update(data);
            SdkData.checkTrue(spi.verify(signature), 50008, RsaPublicKey.class.getName());
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(50001, (Throwable)e);
        }
    }
}

