/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.core.codec;

import com.ionic.sdk.core.codec.BytesTranscoder;
import com.ionic.sdk.core.codec.TranscoderFactory;
import com.ionic.sdk.core.codec.UTF8;
import com.ionic.sdk.core.vm.Version;

public final class Transcoder {
    private static final TranscoderFactory FACTORY = Transcoder.getFactory();
    public static final String BASE64_PAD = "=";
    private static final String IMPL_JRE7 = "com.ionic.sdk.core.codec7.TranscoderFactory7";
    private static final String IMPL_JRE8 = "com.ionic.sdk.core.codec8.TranscoderFactory8";

    private Transcoder() {
    }

    public static BytesTranscoder base64() {
        return FACTORY.base64();
    }

    public static BytesTranscoder hex() {
        return FACTORY.hex();
    }

    public static BytesTranscoder utf8() {
        return new UTF8();
    }

    private static TranscoderFactory getFactory() {
        String className = Version.isJava7() ? IMPL_JRE7 : IMPL_JRE8;
        try {
            return Class.forName(className).asSubclass(TranscoderFactory.class).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException(e);
        }
    }
}

