/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.core.codec8;

import com.ionic.sdk.core.codec.BytesTranscoder;

public final class Hex
implements BytesTranscoder {
    private static final String ALPHABET = "0123456789abcdef";
    private static final char[] ALPHABET_CHARS = "0123456789abcdef".toCharArray();
    private static final int HEX_BYTE = 255;
    private static final int RADIX = 16;

    @Override
    public String encode(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] charsOut = new char[bytes.length * 2];
        int cursor = -1;
        for (byte b : bytes) {
            int i = b & 0xFF;
            charsOut[++cursor] = ALPHABET_CHARS[i / 16];
            charsOut[++cursor] = ALPHABET_CHARS[i % 16];
        }
        return new String(charsOut);
    }

    @Override
    public byte[] decode(String hexText) {
        if (hexText == null) {
            return null;
        }
        int lengthIn = hexText.length();
        if (lengthIn % 2 != 0) {
            throw new IllegalArgumentException(hexText);
        }
        byte[] bytesOut = new byte[lengthIn / 2];
        char[] charsIn = hexText.toCharArray();
        int cursor = 0;
        boolean highNibble = true;
        for (char c : charsIn) {
            int index = ALPHABET.indexOf(c);
            int n = cursor;
            bytesOut[n] = (byte)(bytesOut[n] + (byte)(index << (highNibble ? 4 : 0)));
            cursor += highNibble ? 0 : 1;
            highNibble = !highNibble;
        }
        return bytesOut;
    }
}

