/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.core.date;

import com.ionic.sdk.error.IonicException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public final class DateTime8601 {
    private final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", Locale.getDefault());
    private static final String ISO_8601_MILLI_Z = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String TZ_ID_GMT = "GMT";
    private static final TimeZone TZ_GMT = TimeZone.getTimeZone("GMT");

    public static Date fromString(String date) throws IonicException {
        return new DateTime8601().fromStringInner(date);
    }

    public static String toString(Date date) {
        return new DateTime8601().toStringInner(date);
    }

    private DateTime8601() {
        this.dateFormat.setTimeZone(TZ_GMT);
    }

    private Date fromStringInner(String date) throws IonicException {
        try {
            return this.dateFormat.parse(date);
        }
        catch (ParseException e) {
            throw new IonicException(40001, (Throwable)e);
        }
    }

    private String toStringInner(Date date) {
        return this.dateFormat.format(date);
    }
}

