/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.core.hash;

import com.ionic.sdk.agent.AgentSdk;
import com.ionic.sdk.error.IonicException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;

public final class Hash {
    private static final int HASH_BITS = 256;
    public static final int HASH_BYTES = 32;
    public static final String ALGORITHM = "SHA-256";
    public static final String ALGORITHM_512 = "SHA-512";

    public byte[] sha256(byte[] value) {
        try {
            MessageDigest messageDigest = AgentSdk.getCrypto().getMessageDigestSha256();
            return messageDigest.digest(value);
        }
        catch (IonicException e) {
            throw new IllegalStateException(e);
        }
    }

    public byte[] sha256(InputStream is) throws IOException {
        try {
            byte[] bytes = new byte[65536];
            MessageDigest messageDigest = AgentSdk.getCrypto().getMessageDigestSha256();
            while (is.available() > 0) {
                int count = is.read(bytes);
                messageDigest.update(bytes, 0, count);
            }
            return messageDigest.digest();
        }
        catch (IonicException e) {
            throw new IllegalStateException(e);
        }
    }

    public byte[] sha512(byte[] value) {
        try {
            MessageDigest messageDigest = AgentSdk.getCrypto().getMessageDigestSha512();
            return messageDigest.digest(value);
        }
        catch (IonicException e) {
            throw new IllegalStateException(e);
        }
    }
}

