/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.core.io;

import com.ionic.sdk.core.annotation.InternalUseOnly;

@InternalUseOnly
public final class ByteBlock {
    private final byte[] block;
    private int head;
    private int tail;
    private static final String PATTERN_TO_STRING = "[ByteBlock: hashCode=%x size=%d, head=%d, tail=%d]";

    public ByteBlock(int size) {
        this.block = new byte[size];
        this.head = 0;
        this.tail = 0;
    }

    public void reset() {
        this.head = 0;
        this.tail = 0;
    }

    public int getHead() {
        return this.head;
    }

    public int getTail() {
        return this.tail;
    }

    public int available() {
        return this.tail - this.head;
    }

    public int freeSpace() {
        return this.block.length - (this.tail - this.head);
    }

    public int add(byte[] bytes, int offset, int length) {
        int added = Math.min(this.block.length - this.tail, length);
        System.arraycopy(bytes, offset, this.block, this.tail, added);
        this.tail += added;
        return added;
    }

    public int remove(byte[] bytes, int offset, int length) {
        int count = Math.min(this.tail - this.head, length);
        System.arraycopy(this.block, this.head, bytes, offset, count);
        this.head += count;
        return count;
    }

    public int skip(int count) {
        this.head += count;
        return count;
    }

    public String toString() {
        return String.format(PATTERN_TO_STRING, this.hashCode(), this.block.length, this.head, this.tail);
    }
}

