/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.core.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

public class ByteChannelWindow {
    private final SeekableByteChannel channel;
    private final long start;
    private final long end;

    public ByteChannelWindow(SeekableByteChannel channel, long start, long end) throws IOException {
        this.channel = channel;
        this.channel.position(start);
        this.start = start;
        this.end = end;
    }

    public long getStart() {
        return this.start;
    }

    public long available() throws IOException {
        return this.end - this.channel.position();
    }

    public int read(byte[] bytes) throws IOException {
        int bytesToRead = Math.min(bytes.length, (int)(this.end - this.channel.position()));
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, 0, bytesToRead);
        return this.channel.read(byteBuffer);
    }

    public int read(ByteBuffer byteBuffer) throws IOException {
        int bytesToRead = Math.min(byteBuffer.capacity(), (int)(this.end - this.channel.position()));
        int position = byteBuffer.position();
        byteBuffer.limit(position + bytesToRead);
        int bytesRead = this.channel.read(byteBuffer);
        byteBuffer.position(position);
        return bytesRead;
    }
}

