/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.core.io;

import com.ionic.sdk.core.annotation.InternalUseOnly;
import com.ionic.sdk.core.io.ByteBlock;
import java.util.ArrayDeque;

@InternalUseOnly
public final class ByteQueue {
    private final int size;
    private final ArrayDeque<ByteBlock> queue;
    private final ArrayDeque<ByteBlock> queueFree;
    private ByteBlock headBlock;
    private ByteBlock tailBlock;
    private static final String PATTERN_CURSORS = "%nRead: %s%nWrite: %s";

    public ByteQueue(int size) {
        this.size = size;
        this.queue = new ArrayDeque();
        this.queueFree = new ArrayDeque();
        ByteBlock byteBlock = new ByteBlock(size);
        this.queue.add(byteBlock);
        this.headBlock = byteBlock;
        this.tailBlock = byteBlock;
    }

    public int available() {
        int available = 0;
        for (ByteBlock byteBlock : this.queue) {
            available += byteBlock.available();
        }
        return available;
    }

    public int freeSpace() {
        int freeSpace = 0;
        for (ByteBlock byteBlock : this.queue) {
            freeSpace += byteBlock.freeSpace();
        }
        for (ByteBlock byteBlock : this.queueFree) {
            freeSpace += byteBlock.freeSpace();
        }
        return freeSpace;
    }

    public int addData(byte[] bytes, int offset, int length) {
        int count = 0;
        while (count < length) {
            ByteBlock block = this.tailBlock;
            if ((count += block.add(bytes, offset + count, length - count)) >= length) continue;
            ByteBlock byteBlock = this.queueFree.isEmpty() ? new ByteBlock(this.size) : this.queueFree.pop();
            this.queue.add(byteBlock);
            this.tailBlock = byteBlock;
        }
        return count;
    }

    public int removeData(byte[] bytes, int offset, int length) {
        int count;
        int removed;
        for (count = 0; count < length; count += removed) {
            ByteBlock block = this.headBlock;
            removed = block.remove(bytes, offset + count, length - count);
            if (this.headBlock.equals(this.tailBlock)) break;
            if (block.available() != 0) continue;
            this.queue.remove(block);
            block.reset();
            this.queueFree.add(block);
            this.headBlock = this.queue.getFirst();
        }
        return count;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (ByteBlock byteBlock : this.queue) {
            buffer.append(byteBlock.toString());
        }
        buffer.append(String.format(PATTERN_CURSORS, this.headBlock.toString(), this.tailBlock.toString()));
        return buffer.toString();
    }
}

