/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.core.io;

import com.ionic.sdk.core.io.ByteQueue;
import java.io.InputStream;
import java.nio.ByteBuffer;

public final class ByteQueueInputStream
extends InputStream {
    private final ByteQueue byteQueue;
    private final byte[] byteBuffer;
    private static final int BYTE_MASK = 255;

    public ByteQueueInputStream(int blockSize) {
        this.byteQueue = new ByteQueue(blockSize);
        this.byteBuffer = new byte[1];
    }

    public void addBytes(byte[] bytes, int offset, int length) {
        this.byteQueue.addData(bytes, offset, length);
    }

    public void addBytes(ByteBuffer byteBuffer) {
        int sizeBlock = 65536;
        byte[] block = new byte[65536];
        while (byteBuffer.position() < byteBuffer.limit()) {
            int count = Math.min(byteBuffer.limit() - byteBuffer.position(), block.length);
            byteBuffer.get(block, 0, count);
            this.byteQueue.addData(block, 0, count);
        }
    }

    @Override
    public int read() {
        int b = -1;
        if (this.byteQueue.available() > 0) {
            this.byteQueue.removeData(this.byteBuffer, 0, this.byteBuffer.length);
            b = this.byteBuffer[0] & 0xFF;
        }
        return b;
    }

    @Override
    public int read(byte[] bytes, int offset, int len) {
        int countToRead = Math.min(len, this.byteQueue.available());
        return this.byteQueue.removeData(bytes, offset, countToRead);
    }

    @Override
    public int available() {
        return this.byteQueue.available();
    }
}

