/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.core.io;

import java.io.File;
import java.util.Collection;
import java.util.TreeSet;

public final class FileSystem {
    private FileSystem() {
    }

    public static Collection<File> listFiles(File file, boolean recurse) {
        TreeSet<File> files = new TreeSet<File>();
        FileSystem.addFilesInternal(files, file, true, recurse);
        return files;
    }

    private static void addFilesInternal(Collection<File> files, File file, boolean isRoot, boolean recurse) {
        if (!file.isDirectory()) {
            files.add(file);
        } else if (file.isDirectory() && (isRoot || recurse)) {
            File[] filesIt;
            for (File fileIt : filesIt = FileSystem.listFilesInternal(file)) {
                FileSystem.addFilesInternal(files, fileIt, false, recurse);
            }
        }
    }

    private static File[] listFilesInternal(File folder) {
        File[] files = folder.listFiles();
        return files == null ? new File[]{} : files;
    }
}

