/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.core.io;

import com.ionic.sdk.core.annotation.InternalUseOnly;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;

@InternalUseOnly
public final class SeekableByteBufferChannel
implements SeekableByteChannel {
    private final ByteBuffer byteBuffer;

    public SeekableByteBufferChannel(byte[] bytes) {
        this.byteBuffer = ByteBuffer.wrap(bytes);
    }

    @Override
    public int read(ByteBuffer dst) {
        int length = Math.min(dst.remaining(), this.byteBuffer.remaining());
        if (length > 0) {
            dst.put(this.byteBuffer.array(), this.byteBuffer.position(), length);
            this.byteBuffer.position(this.byteBuffer.position() + length);
        }
        return length > 0 ? length : -1;
    }

    @Override
    public int write(ByteBuffer src) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long position() {
        return this.byteBuffer.position();
    }

    @Override
    public SeekableByteChannel position(long newPosition) {
        this.byteBuffer.position((int)newPosition);
        return this;
    }

    @Override
    public long size() {
        return this.byteBuffer.capacity();
    }

    @Override
    public SeekableByteChannel truncate(long size) throws IOException {
        throw new IOException(new UnsupportedOperationException());
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public void close() {
    }
}

