/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.core.io;

import com.ionic.sdk.error.IonicException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class Stream {
    private Stream() {
    }

    public static void transmit(InputStream is, OutputStream os) throws IOException {
        int b;
        while ((b = is.read()) >= 0) {
            os.write(b);
        }
    }

    public static byte[] read(URL url) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(url.openStream());){
            byte[] byArray = Stream.readInternal(bis, Integer.MAX_VALUE);
            return byArray;
        }
    }

    public static byte[] read(InputStream is) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(is);){
            byte[] byArray = Stream.readInternal(bis, Integer.MAX_VALUE);
            return byArray;
        }
    }

    public static byte[] read(BufferedInputStream bis, int length) throws IOException {
        return Stream.readInternal(bis, length);
    }

    public static byte[] readSlow(File file) throws IOException {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));){
            byte[] byArray = Stream.readInternal(bis, Integer.MAX_VALUE);
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] read(File file) throws IOException {
        byte[] fileDataBytes = new byte[(int)file.length()];
        try (FileInputStream is = new FileInputStream(file);){
            int readLen = is.read(fileDataBytes);
            if ((long)readLen < file.length()) {
                throw new IOException(file.getName());
            }
        }
        return fileDataBytes;
    }

    private static byte[] readInternal(BufferedInputStream is, int length) throws IOException {
        int b;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        int count = 0;
        while ((b = is.read()) >= 0) {
            os.write(b);
            if (++count < length) continue;
            break;
        }
        return os.toByteArray();
    }

    private static void writeInternal(BufferedOutputStream os, BufferedInputStream is) throws IOException {
        int data;
        while ((data = is.read()) >= 0) {
            os.write(data);
        }
    }

    public static void writeToDisk(String path, byte[] dataToWrite) throws IonicException {
        try {
            Files.write(Paths.get(path, new String[0]), dataToWrite, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new IonicException(40013, (Throwable)e);
        }
    }

    public static byte[] loadFileIntoMemory(String fullPath) {
        Path path = null;
        byte[] loadedFile = null;
        try {
            path = FileSystems.getDefault().getPath(fullPath, new String[0]);
        }
        catch (InvalidPathException ie) {
            return null;
        }
        try {
            loadedFile = Files.readAllBytes(path);
        }
        catch (IOException e) {
            return null;
        }
        return loadedFile;
    }

    public static void write(OutputStream os, InputStream is) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(os);
             BufferedInputStream bis = new BufferedInputStream(is);){
            Stream.writeInternal(bos, bis);
        }
    }

    public static void write(OutputStream os, byte[] bytes) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(os);
             BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(bytes));){
            Stream.writeInternal(bos, bis);
        }
    }

    public static void write(File file, byte[] bytes) throws IOException {
        try (BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));){
            os.write(bytes);
        }
    }
}

