/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.core.io;

import com.ionic.sdk.core.codec.Transcoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class StreamFormatter {
    private final int width;
    private final String delimiter;

    public StreamFormatter(int width, String delimiter) {
        this.width = width;
        this.delimiter = delimiter;
    }

    public void write(InputStream is, OutputStream os) throws IOException {
        byte[] delimiterBytes = Transcoder.utf8().decode(this.delimiter);
        byte[] block = new byte[this.width];
        while (is.available() > 0) {
            int count = is.read(block);
            if (count <= 0) continue;
            os.write(block, 0, count);
            os.write(delimiterBytes);
        }
    }
}

