/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.core.rng;

import com.ionic.sdk.error.IonicException;
import java.math.BigInteger;
import java.security.SecureRandom;

public class CryptoRng {
    private final SecureRandom random = new SecureRandom();
    private static final int FIPS_A_5_3_EXTRA_BITS = 64;

    public final byte randByte(byte min, byte max) throws IonicException {
        int i = this.randInternal(max - min);
        return (byte)(i + min);
    }

    public final short randInt16(short min, short max) throws IonicException {
        int i = this.randInternal(max - min);
        return (short)(i + min);
    }

    public final int randInt32(int min, int max) throws IonicException {
        int i = this.randInternal(max - min);
        return i + min;
    }

    private int randInternal(int bound) throws IonicException {
        if (bound <= 0) {
            throw new IonicException(50004);
        }
        return this.random.nextInt(bound);
    }

    public final long randInt64(long min, long max) throws IonicException {
        long bound = max - min;
        if (bound <= 0L) {
            throw new IonicException(50004);
        }
        byte[] bytes = new byte[16];
        this.random.nextBytes(bytes);
        BigInteger randomBI = new BigInteger(bytes).mod(BigInteger.valueOf(bound));
        long i = randomBI.longValue();
        return i + min;
    }

    public final byte[] rand(byte[] bytes) throws IonicException {
        if (bytes == null) {
            throw new IonicException(50003);
        }
        this.random.nextBytes(bytes);
        return bytes;
    }
}

