/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.core.validate;

import com.ionic.sdk.agent.config.AgentConfig;
import com.ionic.sdk.core.validate.Validator;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import java.lang.reflect.Constructor;

public final class ValidatorFactory {
    private ValidatorFactory() {
    }

    public static Validator create(AgentConfig agentConfig) throws IonicException {
        SdkData.checkNotNull(agentConfig, AgentConfig.class.getName());
        String validatorImpl = agentConfig.getProperty(Validator.class.getName());
        return Value.isEmpty(validatorImpl) ? null : ValidatorFactory.createReflect(validatorImpl);
    }

    private static Validator createReflect(String className) throws IonicException {
        try {
            Class<?> c = Class.forName(className);
            Constructor<?> ctor = c.getConstructor(new Class[0]);
            Object object = ctor.newInstance(new Object[0]);
            if (object instanceof Validator) {
                return (Validator)object;
            }
            throw new IonicException(40012, object.getClass().getName());
        }
        catch (ReflectiveOperationException e) {
            throw new IonicException(40012, (Throwable)e);
        }
    }
}

