/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.core.value;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;

public final class Value {
    public static final String DELIMITER_SLASH = "/";
    public static final String DOT = ".";

    private Value() {
    }

    public static boolean isEmpty(byte[] value) {
        return value == null || value.length == 0;
    }

    public static boolean hasNull(Object ... objects) {
        boolean hasNull = false;
        for (Object object : objects) {
            hasNull |= object == null;
        }
        return hasNull;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static String defaultOnEmpty(String value, String defaultValue) {
        return value == null || value.length() == 0 ? defaultValue : value;
    }

    public static boolean isEqual(String left, String right) {
        return left == null ? right == null : left.equals(right);
    }

    public static boolean isEqualIgnoreCase(String left, String right) {
        return left == null ? right == null : left.equalsIgnoreCase(right);
    }

    public static String join(String connector, Object value, Object ... values) {
        StringBuilder buffer = new StringBuilder();
        buffer.append(value);
        for (Object valueIt : values) {
            if (valueIt == null) continue;
            buffer.append(connector);
            buffer.append(valueIt);
        }
        return buffer.toString();
    }

    public static String joinArray(String connector, Object[] values) {
        StringBuilder buffer = new StringBuilder();
        for (Object valueIt : values) {
            Value.append(connector, buffer, valueIt);
        }
        return buffer.toString();
    }

    public static String joinCollection(String connector, Collection<? extends Object> values) {
        StringBuilder buffer = new StringBuilder();
        for (Object object : values) {
            Value.append(connector, buffer, object);
        }
        return buffer.toString();
    }

    private static void append(String connector, StringBuilder buffer, Object valueIt) {
        if (valueIt != null) {
            buffer.append(buffer.length() == 0 ? "" : connector);
            buffer.append(valueIt);
        }
    }

    public static int toInt(String value, int valueDefault) {
        Integer number;
        try {
            number = value == null ? (Number)valueDefault : (Number)NumberFormat.getInstance().parse(value);
        }
        catch (ParseException e) {
            number = valueDefault;
        }
        return number;
    }

    public static String generate(String value, int count) {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            buffer.append(value);
        }
        return buffer.toString();
    }
}

