/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.core.vm;

public enum JavaVersion {
    VERSION_UNRECOGNIZED,
    VERSION_1_7,
    VERSION_1_8,
    VERSION_1_9,
    VERSION_1_10,
    VERSION_1_11,
    VERSION_1_12,
    VERSION_FUTURE;

    private static final String PREFIX_1_7 = "1.7.";
    private static final String PREFIX_1_8 = "1.8.";
    private static final String PREFIX_1_9 = "9.0.";
    private static final String PREFIX_1_10 = "10.0.";
    private static final String PREFIX_1_11 = "11.0.";
    private static final String PREFIX_1_12 = "12.0.";

    public static JavaVersion current() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion == null) {
            throw new IllegalStateException(new NullPointerException("java.version"));
        }
        if (javaVersion.startsWith(PREFIX_1_7)) {
            return VERSION_1_7;
        }
        if (javaVersion.startsWith(PREFIX_1_8)) {
            return VERSION_1_8;
        }
        if (javaVersion.startsWith(PREFIX_1_9)) {
            return VERSION_1_9;
        }
        if (javaVersion.startsWith(PREFIX_1_10)) {
            return VERSION_1_10;
        }
        if (javaVersion.startsWith(PREFIX_1_11)) {
            return VERSION_1_11;
        }
        if (javaVersion.startsWith(PREFIX_1_12)) {
            return VERSION_1_12;
        }
        return VERSION_FUTURE;
    }
}

