/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.core.vm;

import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.error.IonicException;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.TreeSet;

public final class Network {
    private Network() {
    }

    public static String[] getMacAddresses() throws IonicException {
        TreeSet<String> macAddresses = new TreeSet<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                byte[] hardwareAddress = networkInterface.getHardwareAddress();
                if (hardwareAddress == null) continue;
                macAddresses.add(Transcoder.hex().encode(hardwareAddress));
            }
        }
        catch (SocketException e) {
            throw new IonicException(40001, (Throwable)e);
        }
        return macAddresses.toArray(new String[macAddresses.size()]);
    }
}

