/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.crypto;

import com.ionic.sdk.agent.AgentSdk;
import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.hash.Hash;
import com.ionic.sdk.crypto.pbkdf.IonicPbkdf2;
import com.ionic.sdk.error.IonicException;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public final class CryptoUtils {
    public static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA256";
    public static final int SHA256_DIGEST_SIZE = 32;
    public static final int SHA512_DIGEST_SIZE = 64;

    private CryptoUtils() {
    }

    public static byte[] base64ToBin(String buffer) throws IonicException {
        try {
            return Transcoder.base64().decode(buffer);
        }
        catch (RuntimeException e) {
            throw new IonicException(50004, (Throwable)e);
        }
    }

    public static String binToBase64(byte[] buffer) {
        return Transcoder.base64().encode(buffer);
    }

    public static String binToHex(byte[] buffer) {
        return Transcoder.hex().encode(buffer);
    }

    private static byte[] pbkdf2ToBytesInternal(byte[] value, byte[] salt, long iterations, long hashLength) throws IonicException {
        AgentSdk.initialize();
        return new IonicPbkdf2(value, salt, (int)iterations, (int)hashLength).generate();
    }

    public static byte[] pbkdf2ToBytes(byte[] value, byte[] salt, long iterations, long hashLength) throws IonicException {
        return CryptoUtils.pbkdf2ToBytesInternal(value, salt, iterations, hashLength);
    }

    public static String pbkdf2ToHexString(byte[] value, byte[] salt, long iterations, long hashLength) throws IonicException {
        return Transcoder.hex().encode(CryptoUtils.pbkdf2ToBytesInternal(value, salt, iterations, hashLength));
    }

    public static String pbkdf2ToBase64String(byte[] value, byte[] salt, long iterations, long hashLength) throws IonicException {
        return Transcoder.base64().encode(CryptoUtils.pbkdf2ToBytesInternal(value, salt, iterations, hashLength));
    }

    public static byte[] hexToBin(String buffer) throws IonicException {
        try {
            return Transcoder.hex().decode(buffer);
        }
        catch (IllegalArgumentException e) {
            throw new IonicException(50004, (Throwable)e);
        }
    }

    private static byte[] hmacSHA256Internal(byte[] message, byte[] key) throws IonicException {
        try {
            AgentSdk.initialize();
            Mac hmacSHA256 = AgentSdk.getCrypto().getHmacSha256();
            SecretKeySpec keySpec = new SecretKeySpec(key, hmacSHA256.getAlgorithm());
            hmacSHA256.init(keySpec);
            return hmacSHA256.doFinal(message);
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(50001, (Throwable)e);
        }
    }

    private static byte[] hmacSHA256Internal(ByteBuffer byteBuffer, byte[] key) throws IonicException {
        try {
            AgentSdk.initialize();
            Mac hmacSHA256 = AgentSdk.getCrypto().getHmacSha256();
            SecretKeySpec keySpec = new SecretKeySpec(key, hmacSHA256.getAlgorithm());
            hmacSHA256.init(keySpec);
            hmacSHA256.update(byteBuffer);
            return hmacSHA256.doFinal();
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(50001, (Throwable)e);
        }
    }

    public static byte[] hmacSHA256(byte[] message, byte[] key) throws IonicException {
        return CryptoUtils.hmacSHA256Internal(message, key);
    }

    public static byte[] hmacSHA256(ByteBuffer byteBuffer, byte[] key) throws IonicException {
        return CryptoUtils.hmacSHA256Internal(byteBuffer, key);
    }

    public static String hmacSHA256Base64(byte[] message, byte[] key) throws IonicException {
        return Transcoder.base64().encode(CryptoUtils.hmacSHA256Internal(message, key));
    }

    public static byte[] sha256ToBytes(byte[] message) {
        return new Hash().sha256(message);
    }

    public static String sha256ToHexString(byte[] message) {
        return Transcoder.hex().encode(new Hash().sha256(message));
    }

    public static String sha256ToBase64(byte[] message) {
        return Transcoder.base64().encode(new Hash().sha256(message));
    }

    public static byte[] sha512ToBytes(byte[] message) {
        return new Hash().sha512(message);
    }

    public static String sha512ToHexString(byte[] message) {
        return Transcoder.hex().encode(new Hash().sha512(message));
    }
}

