/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.crypto.env;

import com.ionic.sdk.core.codec.Transcoder;
import com.ionic.sdk.core.hash.Hash;
import com.ionic.sdk.core.io.FileSystem;
import com.ionic.sdk.core.value.Value;
import com.ionic.sdk.core.vm.Network;
import com.ionic.sdk.device.DeviceUtils;
import com.ionic.sdk.error.IonicException;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.TreeSet;
import java.util.regex.Pattern;

public final class Environment {
    private Environment() {
    }

    public static String sysProp(String name, String defaultValue) {
        String value = System.getProperty(name);
        return Value.defaultOnEmpty(value, defaultValue);
    }

    public static String sysEnv(String name, String defaultValue) {
        String value = System.getenv(name);
        return Value.defaultOnEmpty(value, defaultValue);
    }

    public static String hostname(String defaultValue) {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return defaultValue;
        }
    }

    public static String netAddresses(String defaultValue) {
        try {
            return Value.joinArray("|", Network.getMacAddresses());
        }
        catch (IonicException e) {
            return defaultValue;
        }
    }

    public static String folderContent(String path, String filter, String defaultValue) {
        TreeSet<String> value = new TreeSet<String>();
        Pattern pattern = Pattern.compile(filter);
        File folder = new File(path);
        Collection<File> files = FileSystem.listFiles(folder, false);
        for (File file : files) {
            if (!pattern.matcher(file.getName()).matches()) continue;
            value.add(file.getName());
        }
        return value.isEmpty() ? defaultValue : Value.joinCollection("|", value);
    }

    public static String fileContentHash(String path, String defaultValue) {
        try {
            return Transcoder.base64().encode(new Hash().sha256(DeviceUtils.readSlow(new File(path))));
        }
        catch (IonicException e) {
            return defaultValue;
        }
    }

    public static String dirEntryTime(String path, String defaultValue) {
        long lastModified = new File(path).lastModified();
        return lastModified == 0L ? defaultValue : Long.toString(lastModified);
    }
}

