/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.crypto.jce;

import com.ionic.sdk.error.IonicException;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.Provider;
import java.security.Signature;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.net.ssl.SSLContext;

public final class CryptoAbstract {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Provider provider;
    public static final String HMAC_ALGORITHM = "HmacSHA256";
    private static final String PBKDF2_ALGORITHM = "PBKDF2WithHmacSHA256";
    private static final String PROVIDER_SUNJCE = "SunJCE";
    private static final String PROVIDER_SUN = "SUN";
    private static final String PROVIDER_SUNJSSE = "SunJSSE";
    private static final String ALGORITHM_RSASIGN = "RSASSA-PSS";
    private static final String PROVIDER_RSASIGN = "SunRsaSign";
    private static final String MASK_GENERATION_RSASIGN = "MGF1";

    public CryptoAbstract(Provider provider) {
        this.provider = provider;
    }

    public Cipher getCipherAesCtr() throws IonicException {
        try {
            return this.provider == null ? Cipher.getInstance("AES/CTR/NoPadding") : Cipher.getInstance("AES/CTR/NoPadding", this.provider);
        }
        catch (GeneralSecurityException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IonicException(50001, (Throwable)e);
        }
    }

    public Cipher getCipherAesGcm() throws IonicException {
        try {
            return this.provider == null ? Cipher.getInstance("AES/GCM/NoPadding") : Cipher.getInstance("AES/GCM/NoPadding", this.provider);
        }
        catch (GeneralSecurityException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IonicException(50001, (Throwable)e);
        }
    }

    public KeyGenerator getKeyGeneratorAes() throws IonicException {
        try {
            return this.provider == null ? KeyGenerator.getInstance("AES") : KeyGenerator.getInstance("AES", this.provider);
        }
        catch (GeneralSecurityException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IonicException(50001, (Throwable)e);
        }
    }

    public Cipher getCipherRsa() throws IonicException {
        try {
            return this.provider == null ? Cipher.getInstance("RSA/ECB/OAEPWITHSHA1ANDMGF1PADDING") : Cipher.getInstance("RSA/ECB/OAEPWITHSHA1ANDMGF1PADDING", this.provider);
        }
        catch (GeneralSecurityException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IonicException(50001, (Throwable)e);
        }
    }

    public Signature getSignatureRsa() throws IonicException {
        try {
            if (this.provider == null) {
                return Signature.getInstance("SHA256withRSA/PSS");
            }
            if (PROVIDER_SUNJCE.equals(this.provider.getName())) {
                Signature signature = Signature.getInstance(ALGORITHM_RSASIGN, PROVIDER_RSASIGN);
                signature.setParameter(new PSSParameterSpec("SHA-256", MASK_GENERATION_RSASIGN, MGF1ParameterSpec.SHA256, 32, 1));
                return signature;
            }
            return Signature.getInstance("SHA256withRSA/PSS", this.provider);
        }
        catch (GeneralSecurityException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IonicException(50001, (Throwable)e);
        }
    }

    public KeyPairGenerator getKeyPairGeneratorRsa() throws IonicException {
        try {
            if (this.provider == null) {
                return KeyPairGenerator.getInstance("RSA");
            }
            if (PROVIDER_SUNJCE.equals(this.provider.getName())) {
                return KeyPairGenerator.getInstance("RSA", PROVIDER_SUNJSSE);
            }
            return KeyPairGenerator.getInstance("RSA", this.provider);
        }
        catch (GeneralSecurityException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IonicException(50001, (Throwable)e);
        }
    }

    public KeyFactory getKeyFactoryRsa() throws IonicException {
        try {
            if (this.provider == null) {
                return KeyFactory.getInstance("RSA");
            }
            if (PROVIDER_SUNJCE.equals(this.provider.getName())) {
                return KeyFactory.getInstance("RSA", PROVIDER_SUNJSSE);
            }
            return KeyFactory.getInstance("RSA", this.provider);
        }
        catch (GeneralSecurityException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IonicException(50001, (Throwable)e);
        }
    }

    public MessageDigest getMessageDigestSha256() throws IonicException {
        try {
            if (this.provider == null) {
                return MessageDigest.getInstance("SHA-256");
            }
            if (PROVIDER_SUNJCE.equals(this.provider.getName())) {
                return MessageDigest.getInstance("SHA-256", PROVIDER_SUN);
            }
            return MessageDigest.getInstance("SHA-256", this.provider);
        }
        catch (GeneralSecurityException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IonicException(50001, (Throwable)e);
        }
    }

    public MessageDigest getMessageDigestSha512() throws IonicException {
        try {
            if (this.provider == null) {
                return MessageDigest.getInstance("SHA-512");
            }
            if (PROVIDER_SUNJCE.equals(this.provider.getName())) {
                return MessageDigest.getInstance("SHA-512", PROVIDER_SUN);
            }
            return MessageDigest.getInstance("SHA-512", this.provider);
        }
        catch (GeneralSecurityException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IonicException(50001, (Throwable)e);
        }
    }

    public SSLContext getSSLContext(String protocol) throws IonicException {
        try {
            return this.provider == null ? SSLContext.getInstance(protocol) : SSLContext.getInstance(protocol, this.provider);
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(50001, (Throwable)e);
        }
    }

    public Mac getHmacSha256() throws IonicException {
        try {
            return this.provider == null ? Mac.getInstance(HMAC_ALGORITHM) : Mac.getInstance(HMAC_ALGORITHM, this.provider);
        }
        catch (GeneralSecurityException e) {
            this.logger.log(Level.SEVERE, e.getMessage(), e);
            throw new IonicException(50001, (Throwable)e);
        }
    }

    public SecretKeyFactory getSecretKeyFactoryPBKDF2() throws IonicException {
        try {
            return this.provider == null ? SecretKeyFactory.getInstance(PBKDF2_ALGORITHM) : SecretKeyFactory.getInstance(PBKDF2_ALGORITHM, this.provider);
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(50001, (Throwable)e);
        }
    }
}

