/*
 * Decompiled with CFR 0.152.
 */
package com.ionic.sdk.crypto.pbkdf;

import com.ionic.sdk.agent.AgentSdk;
import com.ionic.sdk.error.IonicException;
import com.ionic.sdk.error.SdkData;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;

public class IonicPbkdf2 {
    private final Mac hMac;
    private final byte[] state;
    private final byte[] password;
    private final byte[] salt;
    private final int iterationCount;
    private final int keyLength;
    private static final String ALGORITHM_RAW_BYTES = "RawBytes";

    public IonicPbkdf2(byte[] password, byte[] salt, int iterationCount, int keyLength) throws IonicException {
        SdkData.checkTrue(iterationCount > 0, 50004);
        this.hMac = AgentSdk.getCrypto().getHmacSha256();
        this.state = new byte[this.hMac.getMacLength()];
        this.password = Arrays.copyOf(password, password.length);
        this.salt = salt == null ? null : Arrays.copyOf(salt, salt.length);
        this.iterationCount = iterationCount;
        this.keyLength = keyLength * 8;
    }

    public byte[] generate() throws IonicException {
        this.hMac.reset();
        Arrays.fill(this.state, (byte)0);
        try {
            int keyBytes = this.keyLength / 8;
            return Arrays.copyOfRange(this.generateDerivedKey(keyBytes), 0, keyBytes);
        }
        catch (GeneralSecurityException e) {
            throw new IonicException(50001, (Throwable)e);
        }
    }

    private byte[] generateDerivedKey(int var1) throws GeneralSecurityException {
        int var2 = this.hMac.getMacLength();
        int var3 = (var1 + var2 - 1) / var2;
        int lengthVar4 = 4;
        byte[] var4 = new byte[4];
        byte[] var5 = new byte[var3 * var2];
        int var6 = 0;
        SecretKeySpec key = new SecretKeySpec(this.password, ALGORITHM_RAW_BYTES);
        this.hMac.init(key);
        for (int var8 = 1; var8 <= var3; ++var8) {
            int n;
            int initVar9 = 3;
            int var9 = 3;
            do {
                n = var9--;
            } while ((var4[n] = (byte)(var4[n] + 1)) == 0);
            this.f(this.salt, this.iterationCount, var4, var5, var6);
            var6 += var2;
        }
        return var5;
    }

    private void f(byte[] var1, int var2, byte[] var3, byte[] var4, int var5) throws ShortBufferException {
        if (var1 != null) {
            this.hMac.update(var1, 0, var1.length);
        }
        this.hMac.update(var3, 0, var3.length);
        this.hMac.doFinal(this.state, 0);
        System.arraycopy(this.state, 0, var4, var5, this.state.length);
        for (int var6 = 1; var6 < var2; ++var6) {
            this.hMac.update(this.state, 0, this.state.length);
            this.hMac.doFinal(this.state, 0);
            for (int var7 = 0; var7 != this.state.length; ++var7) {
                int n = var5 + var7;
                var4[n] = (byte)(var4[n] ^ this.state[var7]);
            }
        }
    }
}

